"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeBlock = void 0;
var _react = _interopRequireDefault(require("react"));
var _codeEditor = require("@kbn/code-editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/debug/components/code_block.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * A read-only code block with various default settings suitable for displaying API responses, etc
 */
const CodeBlock = ({
  value
}) => {
  return /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    isCopyable: true,
    languageId: "",
    height: "600px",
    width: "100%",
    options: {
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      readOnly: true,
      tabSize: 2,
      lineNumbers: 'off',
      lineNumbersMinChars: 0,
      glyphMargin: false,
      lineDecorationsWidth: 0,
      overviewRulerBorder: false
    },
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  });
};
exports.CodeBlock = CodeBlock;