"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyDebugger = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@kbn/react-query");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _services = require("../../../services");
var _components = require("../../agent_policy/components");
var _ = require("..");
var _code_block = require("./code_block");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/debug/components/agent_policy_debugger.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fetchAgentPolicies = async () => {
  const response = await (0, _hooks.sendGetAgentPolicies)({
    full: true,
    perPage: 100,
    sortOrder: 'asc'
  });
  if (response.error) {
    throw new Error(response.error.message);
  }
  return response;
};
const AgentPolicyDebugger = () => {
  var _data$data$items, _data$data;
  const {
    getHref
  } = (0, _hooks.useLink)();
  const [selectedPolicyId, setSelectedPolicyId] = (0, _react.useState)();

  // TODO: Depending on the number of agent policies, this might need to be switched to
  // `useInfinite` query with an infinite scrolling approach in the dropdown options.
  const {
    data,
    status
  } = (0, _reactQuery.useQuery)(['debug-agent-policies'], fetchAgentPolicies);
  const agentPolicies = (_data$data$items = data === null || data === void 0 ? void 0 : (_data$data = data.data) === null || _data$data === void 0 ? void 0 : _data$data.items) !== null && _data$data$items !== void 0 ? _data$data$items : [];
  const comboBoxOptions = agentPolicies.map(policy => ({
    label: `${policy.name} - ${policy.id}`,
    value: policy.id
  }));
  const selectedOptions = selectedPolicyId ? [comboBoxOptions.find(option => option.value === selectedPolicyId)] : [];
  const selectedAgentPolicy = agentPolicies.find(policy => policy.id === selectedPolicyId);
  const onDelete = () => {
    setSelectedPolicyId(undefined);
    _.queryClient.invalidateQueries(['debug-agent-policies']);
  };
  if (status === 'error') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "Error",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.debug.agentPolicyDebugger.fetchError",
      defaultMessage: "Error fetching Agent Policies",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.agentPolicyDebugger.description",
    defaultMessage: "Search for an Agent Policy using its name or {codeId} value. Use the code block below to diagnose any potential issues with the policy's configuration.",
    values: {
      codeId: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 31
        }
      }, "id")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: `
            min-width: 600px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.debug.agentPolicyDebugger.selectLabel', {
      defaultMessage: 'Select an Agent Policy'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.debug.agentPolicyDebugger.selectLabel', {
      defaultMessage: 'Select an Agent Policy'
    }),
    fullWidth: true,
    options: comboBoxOptions,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: selectedOptions,
    isLoading: status === 'loading',
    onChange: newSelectedOptions => {
      // Handle "clear" action
      if (!newSelectedOptions.length) {
        setSelectedPolicyId(undefined);
      } else {
        setSelectedPolicyId(newSelectedOptions[0].value);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  })), selectedPolicyId && /*#__PURE__*/_react.default.createElement(_components.AgentPolicyDeleteProvider, {
    agentPolicy: selectedAgentPolicy,
    hasFleetServer: (0, _services.policyHasFleetServer)(selectedAgentPolicy),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }, deleteAgentPolicyPrompt => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      onClick: () => deleteAgentPolicyPrompt(selectedPolicyId, onDelete),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyForm.deletePolicyActionText",
      defaultMessage: "Delete policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 23
      }
    }))));
  })), selectedPolicyId && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: getHref('policy_details', {
      policyId: selectedPolicyId
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.agentPolicyDebugger.viewAgentPolicyLink",
    defaultMessage: "View Agent Policy in Fleet UI",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_code_block.CodeBlock, {
    value: JSON.stringify(selectedAgentPolicy, null, 2),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  })));
};
exports.AgentPolicyDebugger = AgentPolicyDebugger;