"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardIdForSpace = getDashboardIdForSpace;
var _common = require("@kbn/spaces-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDashboardIdForSpace(spaceId = _common.DEFAULT_SPACE_ID, res, dashboardId) {
  var _res$item, _installationInfo$add, _installationInfo$add2, _installationInfo$add3, _installationInfo$add4;
  if ((res === null || res === void 0 ? void 0 : (_res$item = res.item) === null || _res$item === void 0 ? void 0 : _res$item.status) !== 'installed') {
    return dashboardId;
  }
  const installationInfo = res.item.installationInfo;
  if (!installationInfo || (installationInfo === null || installationInfo === void 0 ? void 0 : installationInfo.installed_kibana_space_id) === spaceId) {
    return dashboardId;
  }
  return (_installationInfo$add = (_installationInfo$add2 = installationInfo.additional_spaces_installed_kibana) === null || _installationInfo$add2 === void 0 ? void 0 : (_installationInfo$add3 = _installationInfo$add2[spaceId]) === null || _installationInfo$add3 === void 0 ? void 0 : (_installationInfo$add4 = _installationInfo$add3.find(({
    originId
  }) => originId === dashboardId)) === null || _installationInfo$add4 === void 0 ? void 0 : _installationInfo$add4.id) !== null && _installationInfo$add !== void 0 ? _installationInfo$add : dashboardId;
}