"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentListTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _css = require("@emotion/css");
var _services = require("../../../../services");
var _components = require("../../components");
var _hooks = require("../../../../hooks");
var _components2 = require("../../../../../../components");
var _tags = require("../../components/tags");
var _agent_metrics = require("../../services/agent_metrics");
var _agent_upgrade_status = require("./agent_upgrade_status");
var _empty_prompt = require("./empty_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/agent_list_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AGENTS_TABLE_FIELDS = {
  ACTIVE: 'active',
  HOSTNAME: 'local_metadata.host.hostname',
  POLICY: 'policy_id',
  METRICS: 'metrics',
  VERSION: 'local_metadata.elastic.agent.version',
  LAST_CHECKIN: 'last_checkin'
};
function safeMetadata(val) {
  if (typeof val !== 'string') {
    return '-';
  }
  return val;
}
const AgentListTable = props => {
  const {
    agents,
    isLoading,
    agentPoliciesIndexedById,
    renderActions,
    sortField,
    sortOrder,
    onTableChange,
    onSelectionChange,
    selected,
    totalAgents = 0,
    showUpgradeable,
    pagination,
    pageSizeOptions,
    isUsingFilter,
    setEnrollmentFlyoutState,
    clearFilters,
    isCurrentRequestIncremented
  } = props;
  const authz = (0, _hooks.useAuthz)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const latestAgentVersion = (0, _hooks.useAgentVersion)();
  const isAgentSelectable = (0, _react.useCallback)(agent => {
    if (!agent.active) return false;
    if (!agent.policy_id) return true;
    const agentPolicy = agentPoliciesIndexedById[agent.policy_id];
    const isHosted = (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.is_managed) === true;
    return !isHosted;
  }, [agentPoliciesIndexedById]);
  const agentsShown = (0, _react.useMemo)(() => {
    return totalAgents ? showUpgradeable ? agents.filter(agent => isAgentSelectable(agent) && (0, _services.isAgentUpgradeable)(agent)) : agents : [];
  }, [agents, isAgentSelectable, showUpgradeable, totalAgents]);
  const noItemsMessage = isLoading && isCurrentRequestIncremented ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.loadingAgentsMessage",
    defaultMessage: "Loading agents\u2026",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }) : isUsingFilter ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.noFilteredAgentsPrompt",
    defaultMessage: "No agents found. {clearFiltersLink}",
    values: {
      clearFiltersLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => clearFilters(),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.clearFiltersLinkText",
        defaultMessage: "Clear filters",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    hasFleetAddAgentsPrivileges: authz.fleet.addAgents,
    setEnrollmentFlyoutState: setEnrollmentFlyoutState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  });
  const sorting = {
    sort: {
      field: sortField,
      direction: sortOrder
    }
  };
  const columns = [{
    field: AGENTS_TABLE_FIELDS.ACTIVE,
    sortable: false,
    width: '85px',
    name: _i18n.i18n.translate('xpack.fleet.agentList.statusColumnTitle', {
      defaultMessage: 'Status'
    }),
    render: (active, agent) => /*#__PURE__*/_react.default.createElement(_components.AgentHealth, {
      agent: agent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 48
      }
    })
  }, {
    field: AGENTS_TABLE_FIELDS.HOSTNAME,
    sortable: true,
    name: _i18n.i18n.translate('xpack.fleet.agentList.hostColumnTitle', {
      defaultMessage: 'Host'
    }),
    width: '185px',
    render: (host, agent) => {
      var _agent$tags;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "none",
        direction: "column",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: getHref('agent_details', {
          agentId: agent.id
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 13
        }
      }, safeMetadata(host))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_tags.Tags, {
        tags: (_agent$tags = agent.tags) !== null && _agent$tags !== void 0 ? _agent$tags : [],
        color: "subdued",
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 13
        }
      })));
    }
  }, {
    field: AGENTS_TABLE_FIELDS.POLICY,
    sortable: true,
    truncateText: true,
    name: _i18n.i18n.translate('xpack.fleet.agentList.policyColumnTitle', {
      defaultMessage: 'Agent policy'
    }),
    width: '220px',
    render: (policyId, agent) => {
      const agentPolicy = agentPoliciesIndexedById[policyId];
      return agentPolicy && /*#__PURE__*/_react.default.createElement(_components2.AgentPolicySummaryLine, {
        direction: "column",
        policy: agentPolicy,
        agent: agent,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 13
        }
      });
    }
  }, {
    field: AGENTS_TABLE_FIELDS.METRICS,
    sortable: false,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.cpuTooltip",
        defaultMessage: "Average CPU usage in the last 5 minutes. This includes usage from the Agent and the component it supervises. Possible value ranges from 0 to (number of available CPU cores * 100)",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.cpuTitle",
      defaultMessage: "CPU",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 13
      }
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 13
      }
    }))),
    width: '75px',
    render: (metrics, agent) => (0, _agent_metrics.formatAgentCPU)(agent.metrics, agent.policy_id ? agentPoliciesIndexedById[agent.policy_id] : undefined)
  }, {
    field: AGENTS_TABLE_FIELDS.METRICS,
    sortable: false,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.memoryTooltip",
        defaultMessage: "Average memory usage in the last 5 minutes",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.memoryTitle",
      defaultMessage: "Memory",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 13
      }
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 13
      }
    }))),
    width: '90px',
    render: (metrics, agent) => (0, _agent_metrics.formatAgentMemory)(agent.metrics, agent.policy_id ? agentPoliciesIndexedById[agent.policy_id] : undefined)
  }, {
    field: AGENTS_TABLE_FIELDS.LAST_CHECKIN,
    sortable: true,
    name: _i18n.i18n.translate('xpack.fleet.agentList.lastCheckinTitle', {
      defaultMessage: 'Last activity'
    }),
    width: '100px',
    render: lastCheckin => lastCheckin ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.lastActivityTooltip",
        defaultMessage: "Last checked in at {lastCheckin}",
        values: {
          lastCheckin: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
            value: lastCheckin,
            year: "numeric",
            month: "short",
            day: "2-digit",
            timeZoneName: "short",
            hour: "numeric",
            minute: "numeric",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 279,
              columnNumber: 21
            }
          })
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 274,
          columnNumber: 15
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: lastCheckin,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 15
      }
    }))) : undefined
  }, {
    field: AGENTS_TABLE_FIELDS.VERSION,
    sortable: true,
    width: '220px',
    name: _i18n.i18n.translate('xpack.fleet.agentList.versionTitle', {
      defaultMessage: 'Version'
    }),
    render: (version, agent) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      css: (0, _css.css)`
            min-width: 0;
          `,
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      wrap: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 315,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: "eui-textNoWrap",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 17
      }
    }, safeMetadata(version))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_agent_upgrade_status.AgentUpgradeStatus, {
      isAgentUpgradable: !!(isAgentSelectable(agent) && (0, _services.isAgentUpgradeable)(agent)),
      agent: agent,
      latestAgentVersion: latestAgentVersion,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 17
      }
    })))))
  }, {
    name: _i18n.i18n.translate('xpack.fleet.agentList.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      render: renderActions
    }],
    width: '100px'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: "fleet__agentList__table",
    "data-test-subj": "fleetAgentListTable",
    loading: isLoading,
    noItemsMessage: noItemsMessage,
    items: agentsShown,
    itemId: "id",
    columns: columns,
    pagination: {
      pageIndex: pagination.currentPage - 1,
      pageSize: pagination.pageSize,
      totalItemCount: totalAgents,
      pageSizeOptions
    },
    selection: {
      selected,
      onSelectionChange,
      selectable: isAgentSelectable,
      selectableMessage: (selectable, agent) => {
        if (selectable) return '';
        if (!agent.active) {
          return 'This agent is not active';
        }
        if (agent.policy_id && agentPoliciesIndexedById[agent.policy_id].is_managed) {
          return 'This action is not available for agents enrolled in an externally managed agent policy';
        }
        return '';
      }
    },
    onChange: onTableChange,
    sorting: sorting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 5
    }
  });
};
exports.AgentListTable = AgentListTable;