"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildQuery = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildQuery = ({
  agentId,
  datasets,
  logLevels,
  userQuery
}) => {
  // Filter on agent ID
  const agentIdQuery = `${_constants.AGENT_ID_FIELD.name}:${agentId}`;

  // Filter on selected datasets if given, fall back to filtering on dataset: elastic_agent|elastic_agent.*
  const datasetQuery = datasets.length ? datasets.map(dataset => `${_constants.DATASET_FIELD.name}:${dataset}`).join(' or ') : `${_constants.DATASET_FIELD.name}:${_constants.AGENT_DATASET} or ${_constants.DATASET_FIELD.name}:${_constants.AGENT_DATASET_PATTERN}`;

  // Filter on log levels
  const logLevelQuery = logLevels.map(level => `${_constants.LOG_LEVEL_FIELD.name}:${level}`).join(' or ');

  // Agent ID + datasets query
  const agentQuery = `${agentIdQuery} and (${datasetQuery})`;

  // Agent ID + datasets + log levels query
  const baseQuery = logLevelQuery ? `${agentQuery} and (${logLevelQuery})` : agentQuery;

  // Agent ID + datasets + log levels + user input query
  const finalQuery = userQuery ? `(${baseQuery}) and (${userQuery})` : baseQuery;
  return finalQuery;
};
exports.buildQuery = buildQuery;