"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditPackagePolicyPage = exports.EditPackagePolicyForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_read_only_context = require("../../../../integrations/hooks/use_read_only_context");
var _hooks = require("../../../hooks");
var _hooks2 = require("../../../../integrations/hooks");
var _components = require("../../../components");
var _components2 = require("../components");
var _components3 = require("../create_package_policy_page/single_page_layout/components");
var _components4 = require("../create_package_policy_page/components");
var _services = require("../../../services");
var _services2 = require("../../../../../../common/services");
var _root_callout = require("../create_package_policy_page/single_page_layout/root_callout");
var _single_page_layout = require("../create_package_policy_page/single_page_layout");
var _setup_technology = require("../create_package_policy_page/single_page_layout/hooks/setup_technology");
var _components5 = require("./components");
var _hooks3 = require("./hooks");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/edit_package_policy_page/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditPackagePolicyPage = exports.EditPackagePolicyPage = /*#__PURE__*/(0, _react.memo)(() => {
  var _packagePolicy$data$i, _packagePolicy$data, _packagePolicy$data$i2, _packagePolicy$data$i3;
  const {
    params: {
      packagePolicyId,
      policyId
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const packagePolicy = (0, _hooks2.useGetOnePackagePolicy)(packagePolicyId);
  const extensionView = (0, _hooks.useUIExtension)((_packagePolicy$data$i = (_packagePolicy$data = packagePolicy.data) === null || _packagePolicy$data === void 0 ? void 0 : (_packagePolicy$data$i2 = _packagePolicy$data.item) === null || _packagePolicy$data$i2 === void 0 ? void 0 : (_packagePolicy$data$i3 = _packagePolicy$data$i2.package) === null || _packagePolicy$data$i3 === void 0 ? void 0 : _packagePolicy$data$i3.name) !== null && _packagePolicy$data$i !== void 0 ? _packagePolicy$data$i : '', 'package-policy-edit');
  return /*#__PURE__*/_react.default.createElement(EditPackagePolicyForm, {
    packagePolicyId: packagePolicyId,
    policyId: policyId
    // If an extension opts in to this `useLatestPackageVersion` flag, we want to display
    // the edit form in an "upgrade" state regardless of whether the user intended to
    // "edit" their policy or "upgrade" it. This ensures the new policy generated will be
    // set to use the latest version of the package, not its current version.
    ,
    forceUpgrade: extensionView === null || extensionView === void 0 ? void 0 : extensionView.useLatestPackageVersion,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  });
});
const EditPackagePolicyForm = exports.EditPackagePolicyForm = /*#__PURE__*/(0, _react.memo)(({
  packagePolicyId,
  policyId,
  forceUpgrade = false,
  from = 'edit'
}) => {
  var _packagePolicy$packag, _packagePolicy$packag2, _packagePolicy$packag3, _packagePolicy$packag4, _packagePolicy$packag5, _packagePolicy$packag6;
  const {
    application,
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    agents: {
      enabled: isFleetEnabled
    }
  } = (0, _hooks.useConfig)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    canUseMultipleAgentPolicies
  } = (0, _hooks.useMultipleAgentPolicies)();
  const {
    isAgentlessAgentPolicy,
    isAgentlessIntegration
  } = (0, _setup_technology.useAgentless)();
  const {
    // data
    agentPolicies: existingAgentPolicies,
    isLoadingData,
    loadingError,
    packagePolicy,
    originalPackagePolicy,
    packageInfo,
    upgradeDryRunData,
    // form
    formState,
    setFormState,
    isUpgrade,
    isEdited,
    setIsEdited,
    savePackagePolicy,
    hasErrors,
    updatePackagePolicy,
    validationResults
  } = (0, _hooks3.usePackagePolicyWithRelatedData)(packagePolicyId, {
    forceUpgrade
  });
  const hasAgentlessAgentPolicy = (0, _react.useMemo)(() => existingAgentPolicies.length === 1 ? existingAgentPolicies.some(policy => isAgentlessAgentPolicy(policy)) && isAgentlessIntegration(packageInfo) : false, [existingAgentPolicies, isAgentlessAgentPolicy, packageInfo, isAgentlessIntegration]);
  const canWriteIntegrationPolicies = (0, _hooks.useAuthz)().integrations.writeIntegrationPolicies;
  (0, _use_read_only_context.useSetIsReadOnly)(!canWriteIntegrationPolicies);
  const newSecrets = (0, _react.useMemo)(() => {
    if (!packageInfo) {
      return [];
    }
    return (0, _utils.getNewSecrets)({
      packageInfo,
      packagePolicy
    });
  }, [packageInfo, packagePolicy]);
  const [agentPolicies, setAgentPolicies] = (0, _react.useState)([]);
  const [isFirstLoad, setIsFirstLoad] = (0, _react.useState)(true);
  const [newAgentPolicyName, setNewAgentPolicyName] = (0, _react.useState)();

  // make form dirty if new agent policy is selected
  (0, _react.useEffect)(() => {
    if (newAgentPolicyName) {
      setIsEdited(true);
    }
  }, [newAgentPolicyName, setIsEdited]);
  const [hasAgentPolicyError, setHasAgentPolicyError] = (0, _react.useState)(false);
  const agentPoliciesToAdd = (0, _react.useMemo)(() => [...agentPolicies.filter(policy => !existingAgentPolicies.find(existingPolicy => existingPolicy.id === policy.id)).map(policy => policy.name), ...(newAgentPolicyName ? [newAgentPolicyName] : [])], [agentPolicies, existingAgentPolicies, newAgentPolicyName]);
  const agentPoliciesToRemove = (0, _react.useMemo)(() => existingAgentPolicies.filter(existingPolicy => !agentPolicies.find(policy => policy.id === existingPolicy.id)), [agentPolicies, existingAgentPolicies]);
  const agentPoliciesToRemoveIds = (0, _react.useMemo)(() => agentPoliciesToRemove.map(policy => policy.id), [agentPoliciesToRemove]);
  const agentPoliciesToRemoveName = (0, _react.useMemo)(() => agentPoliciesToRemove.map(policy => policy.name), [agentPoliciesToRemove]);

  // Retrieve agent count
  const [agentCount, setAgentCount] = (0, _react.useState)(0);
  const [impactedAgentCount, setImpactedAgentCount] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    const getAgentCount = async () => {
      const policiesToFetchIds = [...packagePolicy.policy_ids, ...agentPoliciesToRemoveIds];
      try {
        const bulkGetAgentPoliciesResponse = await (0, _hooks.sendBulkGetAgentPoliciesForRq)(policiesToFetchIds, {
          ignoreMissing: true
        });
        let count = 0;
        let impactedCount = 0;
        for (const item of bulkGetAgentPoliciesResponse.items) {
          var _item$agents2;
          if (packagePolicy.policy_ids.includes(item.id)) {
            var _item$agents;
            count += (_item$agents = item.agents) !== null && _item$agents !== void 0 ? _item$agents : 0;
          }
          impactedCount += (_item$agents2 = item.agents) !== null && _item$agents2 !== void 0 ? _item$agents2 : 0;
        }
        setAgentCount(count);
        setImpactedAgentCount(impactedCount);
      } catch (err) {
        setAgentCount(0);
        setImpactedAgentCount(0);
      }
    };
    if (isFleetEnabled && (packagePolicy.policy_ids.length > 0 || agentPoliciesToRemoveIds.length > 0)) {
      getAgentCount();
    }
  }, [packagePolicy.policy_ids, agentPoliciesToRemoveIds, isFleetEnabled]);
  const handleExtensionViewOnChange = (0, _react.useCallback)(({
    isValid,
    updatedPolicy
  }) => {
    updatePackagePolicy(updatedPolicy);
    if (isValid !== undefined) {
      setFormState(isValid ? 'VALID' : 'INVALID');
    }
  }, [updatePackagePolicy, setFormState]);

  // Cancel url + Success redirect Path:
  //  if `from === 'edit'` then it links back to Policy Details
  //  if `from === 'package-edit'`, or `upgrade-from-integrations-policy-list` then it links back to the Integration Policy List
  const cancelUrl = (0, _react.useMemo)(() => {
    return from === 'package-edit' && packageInfo ? getHref('integration_details_policies', {
      pkgkey: (0, _services.pkgKeyFromPackageInfo)(packageInfo)
    }) : policyId ? getHref('policy_details', {
      policyId
    }) : getHref('agent_list');
  }, [from, getHref, packageInfo, policyId]);
  const successRedirectPath = (0, _react.useMemo)(() => {
    return (from === 'package-edit' || from === 'upgrade-from-integrations-policy-list') && packageInfo ? getHref('integration_details_policies', {
      pkgkey: (0, _services.pkgKeyFromPackageInfo)(packageInfo)
    }) : policyId ? getHref('policy_details', {
      policyId
    }) : getHref('agent_list');
  }, [from, getHref, packageInfo, policyId]);
  (0, _hooks3.useHistoryBlock)(isEdited);
  (0, _react.useEffect)(() => {
    if (existingAgentPolicies.length > 0 && isFirstLoad) {
      setIsFirstLoad(false);
      setAgentPolicies(existingAgentPolicies);
    }
  }, [existingAgentPolicies, isFirstLoad]);
  const onSubmit = async () => {
    if (formState === 'VALID' && hasErrors) {
      setFormState('INVALID');
      return;
    }
    if ((agentCount !== 0 || agentPolicies.length === 0 || agentPoliciesToAdd.length > 0 || agentPoliciesToRemove.length > 0) && !hasAgentlessAgentPolicy && formState !== 'CONFIRM') {
      setFormState('CONFIRM');
      return;
    }
    let newPolicyId;
    try {
      setFormState('LOADING');
      newPolicyId = await createAgentPolicyIfNeeded();
    } catch (e) {
      setFormState('VALID');
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.fleet.createAgentPolicy.errorNotificationTitle', {
          defaultMessage: 'Unable to create agent policy'
        })
      });
      return;
    }
    const {
      error
    } = await savePackagePolicy({
      policy_ids: newPolicyId ? [...packagePolicy.policy_ids, newPolicyId] : packagePolicy.policy_ids
    });
    if (!error) {
      setIsEdited(false);
      application.navigateToUrl(successRedirectPath);
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.fleet.editPackagePolicy.updatedNotificationTitle', {
          defaultMessage: `Successfully updated ''{packagePolicyName}''`,
          values: {
            packagePolicyName: packagePolicy.name
          }
        }),
        'data-test-subj': 'policyUpdateSuccessToast',
        text: agentCount && agentPolicies.length > 0 ? _i18n.i18n.translate('xpack.fleet.editPackagePolicy.updatedNotificationMessage', {
          defaultMessage: `Fleet will deploy updates to all agents that use the ''{agentPolicyNames}'' policy`,
          values: {
            agentPolicyNames: agentPolicies.map(policy => policy.name).join(', ')
          }
        }) : undefined
      });
    } else {
      if (error.statusCode === 409) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.editPackagePolicy.failedNotificationTitle', {
            defaultMessage: `Error updating ''{packagePolicyName}''`,
            values: {
              packagePolicyName: packagePolicy.name
            }
          }),
          toastMessage: _i18n.i18n.translate('xpack.fleet.editPackagePolicy.failedConflictNotificationMessage', {
            defaultMessage: `Data is out of date. Refresh the page to get the latest policy.`
          })
        });
      } else {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.editPackagePolicy.failedNotificationTitle', {
            defaultMessage: `Error updating ''{packagePolicyName}''`,
            values: {
              packagePolicyName: packagePolicy.name
            }
          })
        });
      }
      setFormState('VALID');
    }
  };
  const extensionView = (0, _hooks.useUIExtension)((_packagePolicy$packag = (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.name) !== null && _packagePolicy$packag !== void 0 ? _packagePolicy$packag : '', 'package-policy-edit');
  const replaceDefineStepView = (0, _hooks.useUIExtension)((_packagePolicy$packag3 = (_packagePolicy$packag4 = packagePolicy.package) === null || _packagePolicy$packag4 === void 0 ? void 0 : _packagePolicy$packag4.name) !== null && _packagePolicy$packag3 !== void 0 ? _packagePolicy$packag3 : '', 'package-policy-replace-define-step');
  const extensionTabsView = (0, _hooks.useUIExtension)((_packagePolicy$packag5 = (_packagePolicy$packag6 = packagePolicy.package) === null || _packagePolicy$packag6 === void 0 ? void 0 : _packagePolicy$packag6.name) !== null && _packagePolicy$packag5 !== void 0 ? _packagePolicy$packag5 : '', 'package-policy-edit-tabs');
  if (replaceDefineStepView && extensionView) {
    throw new Error("'package-policy-create' and 'package-policy-replace-define-step' cannot both be registered as UI extensions");
  }
  const tabsViews = extensionTabsView === null || extensionTabsView === void 0 ? void 0 : extensionTabsView.tabs;
  const [selectedTab, setSelectedTab] = (0, _react.useState)(0);
  const layoutProps = {
    from: extensionView !== null && extensionView !== void 0 && extensionView.useLatestPackageVersion && isUpgrade ? 'upgrade-from-extension' : from,
    cancelUrl,
    agentPolicies,
    packageInfo,
    tabs: tabsViews !== null && tabsViews !== void 0 && tabsViews.length ? [{
      title: _i18n.i18n.translate('xpack.fleet.editPackagePolicy.settingsTabName', {
        defaultMessage: 'Settings'
      }),
      isSelected: selectedTab === 0,
      onClick: () => {
        setSelectedTab(0);
      }
    }, ...tabsViews.map(({
      title
    }, index) => ({
      title,
      isSelected: selectedTab === index + 1,
      onClick: () => {
        setSelectedTab(index + 1);
      }
    }))] : []
  };
  const configurePackage = (0, _react.useMemo)(() => {
    var _packagePolicy$packag7;
    return agentPolicies && packageInfo ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedTab === 0 && /*#__PURE__*/_react.default.createElement(_components4.StepDefinePackagePolicy, {
      namespacePlaceholder: (0, _services2.getInheritedNamespace)(agentPolicies),
      packageInfo: packageInfo,
      packagePolicy: packagePolicy,
      updatePackagePolicy: updatePackagePolicy,
      validationResults: validationResults,
      submitAttempted: formState === 'INVALID',
      isEditPage: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 414,
        columnNumber: 13
      }
    }), !extensionView && selectedTab === 0 && /*#__PURE__*/_react.default.createElement(_components4.StepConfigurePackagePolicy, {
      packageInfo: packageInfo,
      packagePolicy: packagePolicy,
      updatePackagePolicy: updatePackagePolicy,
      validationResults: validationResults,
      submitAttempted: formState === 'INVALID',
      isEditPage: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 427,
        columnNumber: 13
      }
    }), extensionView && packagePolicy.policy_ids[0] && ((_packagePolicy$packag7 = packagePolicy.package) === null || _packagePolicy$packag7 === void 0 ? void 0 : _packagePolicy$packag7.name) && originalPackagePolicy && /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 441,
        columnNumber: 15
      }
    }, selectedTab > 0 && tabsViews ? (/*#__PURE__*/_react.default.createElement(tabsViews[selectedTab - 1].Component, {
      policy: originalPackagePolicy,
      newPolicy: packagePolicy,
      onChange: handleExtensionViewOnChange
    })) : /*#__PURE__*/_react.default.createElement(extensionView.Component, {
      policy: originalPackagePolicy,
      newPolicy: packagePolicy,
      onChange: handleExtensionViewOnChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 449,
        columnNumber: 19
      }
    }))) : null;
  }, [agentPolicies, packageInfo, packagePolicy, updatePackagePolicy, validationResults, formState, originalPackagePolicy, extensionView, handleExtensionViewOnChange, selectedTab, tabsViews]);
  const replaceConfigurePackage = replaceDefineStepView && originalPackagePolicy && packageInfo && /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 475,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(replaceDefineStepView.Component, {
    agentPolicies: agentPolicies,
    packageInfo: packageInfo,
    policy: originalPackagePolicy,
    newPolicy: packagePolicy,
    onChange: handleExtensionViewOnChange,
    validationResults: validationResults,
    isEditPage: true,
    isAgentlessEnabled: hasAgentlessAgentPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 476,
      columnNumber: 7
    }
  }));
  const rootPrivilegedDataStreams = packageInfo ? (0, _services2.getRootPrivilegedDataStreams)(packageInfo) : [];
  const agentPolicyBreadcrumb = (0, _react.useMemo)(() => {
    var _existingAgentPolicie;
    return existingAgentPolicies.length > 0 ? (_existingAgentPolicie = existingAgentPolicies.find(policy => policy.id === policyId)) !== null && _existingAgentPolicie !== void 0 ? _existingAgentPolicie : existingAgentPolicies[0] : {
      name: '',
      id: ''
    };
  }, [existingAgentPolicies, policyId]);
  const {
    steps,
    devToolsProps: {
      devtoolRequest,
      devtoolRequestDescription,
      showDevtoolsRequest
    },
    createAgentPolicyIfNeeded
  } = (0, _hooks3.usePackagePolicySteps)({
    configureStep: replaceConfigurePackage || configurePackage,
    packageInfo,
    existingAgentPolicies,
    setHasAgentPolicyError,
    updatePackagePolicy,
    agentPolicies,
    setAgentPolicies,
    isLoadingData,
    packagePolicy,
    packagePolicyId,
    setNewAgentPolicyName
  });
  return /*#__PURE__*/_react.default.createElement(_components3.CreatePackagePolicySinglePageLayout, (0, _extends2.default)({}, layoutProps, {
    "data-test-subj": "editPackagePolicy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 516,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 517,
      columnNumber: 7
    }
  }, isLoadingData ? /*#__PURE__*/_react.default.createElement(_components.Loading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 519,
      columnNumber: 11
    }
  }) : loadingError || !packageInfo ? /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.editPackagePolicy.errorLoadingDataTitle",
      defaultMessage: "Error loading data",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 523,
        columnNumber: 15
      }
    }),
    error: loadingError || _i18n.i18n.translate('xpack.fleet.editPackagePolicy.errorLoadingDataMessage', {
      defaultMessage: 'There was an error loading this integration information'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 521,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Breadcrumb, {
    agentPolicyName: agentPolicyBreadcrumb.name,
    from: from,
    packagePolicyName: packagePolicy.name,
    pkgkey: (0, _services.pkgKeyFromPackageInfo)(packageInfo),
    pkgTitle: packageInfo.title,
    policyId: agentPolicyBreadcrumb.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 537,
      columnNumber: 13
    }
  }), formState === 'CONFIRM' && /*#__PURE__*/_react.default.createElement(_components2.ConfirmDeployAgentPolicyModal, {
    agentCount: impactedAgentCount,
    agentPolicies: agentPolicies,
    onConfirm: onSubmit,
    onCancel: () => setFormState('VALID'),
    agentPoliciesToAdd: agentPoliciesToAdd,
    agentPoliciesToRemove: agentPoliciesToRemoveName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 546,
      columnNumber: 15
    }
  }), packageInfo && (0, _services2.isRootPrivilegesRequired)(packageInfo) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_root_callout.RootPrivilegesCallout, {
    dataStreams: rootPrivilegedDataStreams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 557,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 558,
      columnNumber: 17
    }
  })) : null, isUpgrade && upgradeDryRunData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components5.UpgradeStatusCallout, {
    dryRunData: upgradeDryRunData,
    newSecrets: newSecrets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 563,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 564,
      columnNumber: 17
    }
  })), canUseMultipleAgentPolicies && !hasAgentlessAgentPolicy ? /*#__PURE__*/_react.default.createElement(_single_page_layout.StepsWithLessPadding, {
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 568,
      columnNumber: 15
    }
  }) : replaceConfigurePackage || configurePackage, formState === 'LOADING' ? /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, {
    headerZindexLocation: "below",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 573,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_components.Loading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 574,
      columnNumber: 17
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 578,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 579,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 581,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 582,
      columnNumber: 17
    }
  }, agentPolicies && packageInfo && (formState === 'INVALID' || hasAgentPolicyError) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.errorOnSaveText",
    defaultMessage: "Your integration policy has errors. Please fix them before saving.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 586,
      columnNumber: 21
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 592,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 593,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 594,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    href: cancelUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 595,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editPackagePolicy.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 596,
      columnNumber: 25
    }
  }))), showDevtoolsRequest ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 603,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_components.DevtoolsRequestFlyoutButton, {
    isDisabled: formState !== 'VALID',
    btnProps: {
      color: 'text'
    },
    request: devtoolRequest,
    description: devtoolRequestDescription,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 604,
      columnNumber: 25
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 614,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_components.EuiButtonWithTooltip, {
    onClick: onSubmit,
    isLoading: formState === 'LOADING'
    // Allow to save only if the package policy is upgraded or had been edited
    ,
    isDisabled: !canWriteIntegrationPolicies || formState !== 'VALID' || hasAgentPolicyError || !validationResults || !isEdited && !isUpgrade,
    tooltip: !canWriteIntegrationPolicies ? {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicy.saveIntegrationTooltip",
        defaultMessage: "To save the integration policy, you must have security enabled and have the All privilege for Integrations and Agent Policies. Contact your administrator.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 630,
          columnNumber: 35
        }
      })
    } : undefined,
    iconType: "save",
    color: "primary",
    fill: true,
    "data-test-subj": "saveIntegration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 615,
      columnNumber: 23
    }
  }, isUpgrade ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editPackagePolicy.upgradeButton",
    defaultMessage: "Upgrade integration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 644,
      columnNumber: 27
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editPackagePolicy.saveButton",
    defaultMessage: "Save integration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 649,
      columnNumber: 27
    }
  }))))))))));
});
const Breadcrumb = /*#__PURE__*/(0, _react.memo)(({
  agentPolicyName,
  from,
  packagePolicyName,
  pkgkey,
  pkgTitle,
  policyId
}) => {
  let breadcrumb = /*#__PURE__*/_react.default.createElement(PoliciesBreadcrumb, {
    policyName: agentPolicyName,
    policyId: policyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 675,
      columnNumber: 20
    }
  });
  if (from === 'package' || from === 'package-edit') {
    breadcrumb = /*#__PURE__*/_react.default.createElement(IntegrationsBreadcrumb, {
      pkgkey: pkgkey,
      pkgTitle: pkgTitle,
      policyName: packagePolicyName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 679,
        columnNumber: 7
      }
    });
  } else if (from === 'upgrade-from-integrations-policy-list') {
    breadcrumb = /*#__PURE__*/_react.default.createElement(IntegrationsUpgradeBreadcrumb, {
      pkgkey: pkgkey,
      pkgTitle: pkgTitle,
      policyName: packagePolicyName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 683,
        columnNumber: 7
      }
    });
  } else if (from === 'upgrade-from-fleet-policy-list') {
    breadcrumb = /*#__PURE__*/_react.default.createElement(UpgradeBreadcrumb, {
      policyName: agentPolicyName,
      policyId: policyId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 690,
        columnNumber: 18
      }
    });
  }
  return breadcrumb;
});
const IntegrationsBreadcrumb = /*#__PURE__*/(0, _react.memo)(({
  pkgTitle,
  policyName,
  pkgkey
}) => {
  (0, _hooks2.useBreadcrumbs)('integration_policy_edit', {
    policyName,
    pkgTitle,
    pkgkey
  });
  return null;
});
const PoliciesBreadcrumb = ({
  policyName,
  policyId
}) => {
  (0, _hooks.useBreadcrumbs)('edit_integration', {
    policyName,
    policyId
  });
  return null;
};
const IntegrationsUpgradeBreadcrumb = /*#__PURE__*/(0, _react.memo)(({
  pkgTitle,
  policyName,
  pkgkey
}) => {
  (0, _hooks2.useBreadcrumbs)('integration_policy_upgrade', {
    policyName,
    pkgTitle,
    pkgkey
  });
  return null;
});
const UpgradeBreadcrumb = ({
  policyName,
  policyId
}) => {
  (0, _hooks.useBreadcrumbs)('upgrade_package_policy', {
    policyName,
    policyId
  });
  return null;
};