"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFleetServerHost = void 0;
var _react = require("react");
var _hooks = require("../../../hooks");
var _use_fleet_server_host_form = require("../../../sections/settings/components/fleet_server_hosts_flyout/use_fleet_server_host_form");
var _types = require("../../../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFleetServerHost = () => {
  var _fleetServerHost$is_p, _fleetServerHost$ssl$, _fleetServerHost$ssl, _fleetServerHost$ssl$2, _fleetServerHost$ssl2, _fleetServerHost$ssl$3, _fleetServerHost$ssl3, _fleetServerHost$ssl$4, _fleetServerHost$ssl4, _fleetServerHost$ssl$5, _fleetServerHost$ssl5, _fleetServerHost$ssl$6, _fleetServerHost$ssl6, _fleetServerHost$ssl$7, _fleetServerHost$ssl7, _secrets, _secrets$ssl, _secrets2, _secrets2$ssl;
  const [fleetServerHost, setFleetServerHost] = (0, _react.useState)();
  const [isFleetServerHostSubmitted, setIsFleetServerHostSubmitted] = (0, _react.useState)(false);
  const isPreconfigured = (_fleetServerHost$is_p = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : fleetServerHost.is_preconfigured) !== null && _fleetServerHost$is_p !== void 0 ? _fleetServerHost$is_p : false;
  const nameInput = (0, _hooks.useInput)('', _use_fleet_server_host_form.validateName, isPreconfigured);
  const isDefaultInput = (0, _hooks.useSwitchInput)(false, isPreconfigured || (fleetServerHost === null || fleetServerHost === void 0 ? void 0 : fleetServerHost.is_default));
  const hostUrlsInput = (0, _hooks.useComboInput)('hostUrls', [], _use_fleet_server_host_form.validateFleetServerHosts, isPreconfigured);
  const sslCertificateAuthoritiesInput = (0, _hooks.useComboInput)('sslCertificateAuthoritiesComboxBox', (_fleetServerHost$ssl$ = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl = fleetServerHost.ssl) === null || _fleetServerHost$ssl === void 0 ? void 0 : _fleetServerHost$ssl.certificate_authorities) !== null && _fleetServerHost$ssl$ !== void 0 ? _fleetServerHost$ssl$ : [], undefined, undefined);
  const sslCertificateInput = (0, _hooks.useInput)((_fleetServerHost$ssl$2 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl2 = fleetServerHost.ssl) === null || _fleetServerHost$ssl2 === void 0 ? void 0 : _fleetServerHost$ssl2.certificate) !== null && _fleetServerHost$ssl$2 !== void 0 ? _fleetServerHost$ssl$2 : '', () => undefined, undefined);
  const sslEsCertificateAuthoritiesInput = (0, _hooks.useComboInput)('sslEsCertificateAuthoritiesComboxBox', (_fleetServerHost$ssl$3 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl3 = fleetServerHost.ssl) === null || _fleetServerHost$ssl3 === void 0 ? void 0 : _fleetServerHost$ssl3.es_certificate_authorities) !== null && _fleetServerHost$ssl$3 !== void 0 ? _fleetServerHost$ssl$3 : [], undefined, undefined);
  const sslEsCertificateInput = (0, _hooks.useInput)((_fleetServerHost$ssl$4 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl4 = fleetServerHost.ssl) === null || _fleetServerHost$ssl4 === void 0 ? void 0 : _fleetServerHost$ssl4.es_certificate) !== null && _fleetServerHost$ssl$4 !== void 0 ? _fleetServerHost$ssl$4 : '', () => undefined, undefined);
  const sslClientAuthInput = (0, _hooks.useRadioInput)((_fleetServerHost$ssl$5 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl5 = fleetServerHost.ssl) === null || _fleetServerHost$ssl5 === void 0 ? void 0 : _fleetServerHost$ssl5.client_auth) !== null && _fleetServerHost$ssl$5 !== void 0 ? _fleetServerHost$ssl$5 : _types.clientAuth.None, undefined);
  const sslKeyInput = (0, _hooks.useInput)((_fleetServerHost$ssl$6 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl6 = fleetServerHost.ssl) === null || _fleetServerHost$ssl6 === void 0 ? void 0 : _fleetServerHost$ssl6.key) !== null && _fleetServerHost$ssl$6 !== void 0 ? _fleetServerHost$ssl$6 : '', undefined, undefined);
  const sslESKeyInput = (0, _hooks.useInput)((_fleetServerHost$ssl$7 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl7 = fleetServerHost.ssl) === null || _fleetServerHost$ssl7 === void 0 ? void 0 : _fleetServerHost$ssl7.es_key) !== null && _fleetServerHost$ssl$7 !== void 0 ? _fleetServerHost$ssl$7 : '', undefined, undefined);
  const sslKeySecretInput = (0, _hooks.useSecretInput)(fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_secrets = fleetServerHost.secrets) === null || _secrets === void 0 ? void 0 : (_secrets$ssl = _secrets.ssl) === null || _secrets$ssl === void 0 ? void 0 : _secrets$ssl.key, undefined, undefined);
  const sslESKeySecretInput = (0, _hooks.useSecretInput)(fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_secrets2 = fleetServerHost.secrets) === null || _secrets2 === void 0 ? void 0 : (_secrets2$ssl = _secrets2.ssl) === null || _secrets2$ssl === void 0 ? void 0 : _secrets2$ssl.es_key, undefined, undefined);
  const inputs = (0, _react.useMemo)(() => ({
    nameInput,
    isDefaultInput,
    hostUrlsInput,
    sslCertificateAuthoritiesInput,
    sslCertificateInput,
    sslEsCertificateAuthoritiesInput,
    sslEsCertificateInput,
    sslKeyInput,
    sslESKeyInput,
    sslKeySecretInput,
    sslESKeySecretInput,
    sslClientAuthInput
  }), [nameInput, isDefaultInput, hostUrlsInput, sslCertificateAuthoritiesInput, sslCertificateInput, sslEsCertificateAuthoritiesInput, sslEsCertificateInput, sslKeyInput, sslESKeyInput, sslKeySecretInput, sslESKeySecretInput, sslClientAuthInput]);
  const validate = (0, _react.useCallback)(() => (0, _hooks.validateInputs)({
    ...inputs
  }), [inputs]);
  const {
    data,
    resendRequest: refreshGetFleetServerHosts
  } = (0, _hooks.useGetFleetServerHosts)();
  const fleetServerHosts = (0, _react.useMemo)(() => {
    var _data$items;
    return (_data$items = data === null || data === void 0 ? void 0 : data.items) !== null && _data$items !== void 0 ? _data$items : [];
  }, [data === null || data === void 0 ? void 0 : data.items]);
  const setDefaultInputValue = isDefaultInput.setValue;
  (0, _react.useEffect)(() => {
    const defaultHost = fleetServerHosts.find(item => item.is_default === true);
    if (defaultHost) {
      setFleetServerHost(defaultHost);
      setDefaultInputValue(false);
    } else {
      setFleetServerHost(null);
      setDefaultInputValue(true);
    }
  }, [fleetServerHosts, setDefaultInputValue]);
  const handleSubmitForm = (0, _react.useCallback)(async () => {
    if (!validate()) {
      return;
    }
    setIsFleetServerHostSubmitted(false);
    const newFleetServerHost = {
      name: nameInput.value,
      host_urls: hostUrlsInput.value,
      is_default: isDefaultInput.value,
      ssl: {
        certificate: sslCertificateInput.value,
        key: sslKeyInput.value || undefined,
        certificate_authorities: sslCertificateAuthoritiesInput.value.filter(val => val !== ''),
        es_certificate: sslEsCertificateInput.value,
        es_key: sslESKeyInput.value || undefined,
        es_certificate_authorities: sslEsCertificateAuthoritiesInput.value.filter(val => val !== ''),
        ...(sslClientAuthInput.value !== _types.clientAuth.None && {
          client_auth: sslClientAuthInput.value
        })
      },
      ...((!sslKeyInput.value && sslKeySecretInput.value || !sslESKeyInput.value && sslESKeySecretInput.value) && {
        secrets: {
          ssl: {
            key: sslKeySecretInput.value || undefined,
            es_key: sslESKeySecretInput.value || undefined
          }
        }
      })
    };
    const res = await (0, _hooks.sendPostFleetServerHost)(newFleetServerHost);
    if (res.error) {
      throw res.error;
    }
    if (!res.data) {
      throw new Error('No data');
    }
    await refreshGetFleetServerHosts();
    setIsFleetServerHostSubmitted(true);
    setFleetServerHost(res.data.item);
    return res.data.item;
  }, [validate, nameInput.value, hostUrlsInput.value, isDefaultInput.value, sslCertificateInput.value, sslKeyInput.value, sslCertificateAuthoritiesInput.value, sslEsCertificateInput.value, sslESKeyInput.value, sslEsCertificateAuthoritiesInput.value, sslClientAuthInput.value, sslKeySecretInput.value, sslESKeySecretInput.value, refreshGetFleetServerHosts]);
  return {
    fleetServerHosts,
    handleSubmitForm,
    fleetServerHost,
    isFleetServerHostSubmitted,
    setFleetServerHost,
    inputs
  };
};
exports.useFleetServerHost = useFleetServerHost;