"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RETRYABLE_SERVER_CODES = exports.RETRYABLE_HTTP_STATUSES = exports.MAXIMUM_RETRIES = exports.AGENTLESS_GLOBAL_TAG_NAME_TEAM = exports.AGENTLESS_GLOBAL_TAG_NAME_ORGANIZATION = exports.AGENTLESS_GLOBAL_TAG_NAME_DIVISION = exports.AGENTLESS_DISABLED_INPUTS = exports.AGENTLESS_API_ERROR_CODES = exports.AGENTLESS_ALLOWED_OUTPUT_TYPES = exports.AGENTLESS_AGENT_POLICY_MONITORING = exports.AGENTLESS_AGENT_POLICY_INACTIVITY_TIMEOUT = void 0;
var _output = require("./output");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENTLESS_AGENT_POLICY_INACTIVITY_TIMEOUT = exports.AGENTLESS_AGENT_POLICY_INACTIVITY_TIMEOUT = 3600;
const AGENTLESS_AGENT_POLICY_MONITORING = exports.AGENTLESS_AGENT_POLICY_MONITORING = ['logs', 'metrics'];
const AGENTLESS_GLOBAL_TAG_NAME_ORGANIZATION = exports.AGENTLESS_GLOBAL_TAG_NAME_ORGANIZATION = 'organization';
const AGENTLESS_GLOBAL_TAG_NAME_DIVISION = exports.AGENTLESS_GLOBAL_TAG_NAME_DIVISION = 'division';
const AGENTLESS_GLOBAL_TAG_NAME_TEAM = exports.AGENTLESS_GLOBAL_TAG_NAME_TEAM = 'team';
const MAXIMUM_RETRIES = exports.MAXIMUM_RETRIES = 3;
const HTTP_500_INTERNAL_SERVER_ERROR = 500;
const HTTP_502_BAD_GATEWAY = 502;
const HTTP_503_SERVICE_UNAVAILABLE = 503;
const HTTP_504_GATEWAY_TIMEOUT = 504;
const ECONNREFUSED_CODE = 'ECONNREFUSED';
const RETRYABLE_HTTP_STATUSES = exports.RETRYABLE_HTTP_STATUSES = [HTTP_500_INTERNAL_SERVER_ERROR, HTTP_502_BAD_GATEWAY, HTTP_503_SERVICE_UNAVAILABLE, HTTP_504_GATEWAY_TIMEOUT];
const RETRYABLE_SERVER_CODES = exports.RETRYABLE_SERVER_CODES = [ECONNREFUSED_CODE];
// Allowed output types for agentless integrations
const AGENTLESS_ALLOWED_OUTPUT_TYPES = exports.AGENTLESS_ALLOWED_OUTPUT_TYPES = [_output.outputType.Elasticsearch];
const AGENTLESS_API_ERROR_CODES = exports.AGENTLESS_API_ERROR_CODES = {
  OVER_PROVISIONED: 'OVER_PROVISIONED',
  FLEET_UNREACHABLE: 'FLEET_UNREACHABLE'
};

// Input types to disable for agentless integrations
const AGENTLESS_DISABLED_INPUTS = exports.AGENTLESS_DISABLED_INPUTS = ['tcp', 'udp', 'filestream', 'http_endpoint', 'winlog', 'o365audit', 'gcp-pubsub', 'azure-eventhub', 'logfile', 'aws-s3', 'streaming', 'gcs', 'azure-blob-storage'];