"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMaxBytes = getMaxBytes;
exports.getMaxBytesFormatted = getMaxBytesFormatted;
exports.getMaxTikaBytes = getMaxTikaBytes;
exports.getMaxTikaBytesFormatted = getMaxTikaBytesFormatted;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _constants = require("@kbn/file-upload-common/src/constants");
var _kibana_services = require("../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getMaxBytes() {
  const maxFileSize = (0, _kibana_services.getUiSettings)().get(_constants.UI_SETTING_MAX_FILE_SIZE, _constants.MAX_FILE_SIZE);
  // @ts-ignore
  const maxBytes = (0, _numeral.default)(maxFileSize.toUpperCase()).value();
  if (maxBytes < _constants.MAX_FILE_SIZE_BYTES) {
    return _constants.MAX_FILE_SIZE_BYTES;
  }
  return maxBytes <= _constants.ABSOLUTE_MAX_FILE_SIZE_BYTES ? maxBytes : _constants.ABSOLUTE_MAX_FILE_SIZE_BYTES;
}
function getMaxBytesFormatted() {
  return (0, _numeral.default)(getMaxBytes()).format(_constants.FILE_SIZE_DISPLAY_FORMAT);
}
function getMaxTikaBytes() {
  return _constants.MAX_TIKA_FILE_SIZE_BYTES;
}
function getMaxTikaBytesFormatted() {
  return (0, _numeral.default)(getMaxTikaBytes()).format(_constants.FILE_SIZE_DISPLAY_FORMAT);
}