"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPartialImportMessage = getPartialImportMessage;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getPartialImportMessage(failedFeaturesCount, totalFeaturesCount) {
  const outOfTotalMsg = typeof totalFeaturesCount === 'number' ? _i18n.i18n.translate('xpack.fileUpload.geoUploadWizard.outOfTotalMsg', {
    defaultMessage: 'of {totalFeaturesCount}',
    values: {
      totalFeaturesCount
    }
  }) : '';
  return _i18n.i18n.translate('xpack.fileUpload.geoUploadWizard.partialImportMsg', {
    defaultMessage: 'Unable to index {failedFeaturesCount} {outOfTotalMsg} features.',
    values: {
      failedFeaturesCount,
      outOfTotalMsg
    }
  });
}