"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileReaderBase = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STRING_CHUNKS_MB = 100;
class FileReaderBase {
  constructor() {
    (0, _defineProperty2.default)(this, "_docArray", []);
  }
  read(data) {
    let docArray = [];
    const decoder = new TextDecoder();
    const size = STRING_CHUNKS_MB * _constants.MB;

    // chop the data up into 100MB chunks for processing.
    // if the chop produces a partial line at the end, a character "remainder" count
    // is returned which is used to roll the next chunk back that many chars so
    // it is included in the next chunk.
    const parts = Math.ceil(data.byteLength / size);
    let remainder = 0;
    for (let i = 0; i < parts; i++) {
      const byteArray = decoder.decode(data.slice(i * size - remainder, (i + 1) * size));
      const {
        success,
        docs,
        remainder: tempRemainder
      } = this._createDocs(byteArray, i === parts - 1);
      if (success) {
        docArray = docArray.concat(docs);
        remainder = tempRemainder;
      } else {
        throw new Error(`Failed to create docs from chunk ${i}`);
      }
    }
    return docArray;
  }
}
exports.FileReaderBase = FileReaderBase;