"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findFieldsMetadataResponsePayloadRT = exports.findFieldsMetadataRequestQueryRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _Either = require("fp-ts/Either");
var rt = _interopRequireWildcard(require("io-ts"));
var _errors = require("../errors");
var _types = require("../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const baseFindFieldsMetadataRequestQueryRT = rt.exact(rt.partial({
  attributes: _ioTsUtils.arrayToStringRt.pipe(rt.array(_types.fieldAttributeRT)),
  fieldNames: _ioTsUtils.arrayToStringRt.pipe(rt.array(rt.string)),
  source: rt.union([_types.fieldSourceRT, rt.array(_types.fieldSourceRT)]),
  integration: rt.string,
  dataset: rt.string
}));

// Define a refinement that enforces the constraint
const findFieldsMetadataRequestQueryRT = exports.findFieldsMetadataRequestQueryRT = new rt.Type('FindFieldsMetadataRequestQuery', query => baseFindFieldsMetadataRequestQueryRT.is(query) && (query.integration ? query.dataset !== undefined : true), (input, context) => _Either.either.chain(baseFindFieldsMetadataRequestQueryRT.validate(input, context), query => {
  try {
    if (query.integration && !query.dataset) {
      throw new _errors.FetchFieldsMetadataError('dataset is required if integration is provided');
    }
    return rt.success(query);
  } catch (error) {
    return rt.failure(query, context, error.message);
  }
}), baseFindFieldsMetadataRequestQueryRT.encode);
const findFieldsMetadataResponsePayloadRT = exports.findFieldsMetadataResponsePayloadRT = rt.type({
  fields: rt.record(rt.string, _types.partialFieldMetadataPlainRT)
});