"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TagCloudChart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _chartIcons = require("@kbn/chart-icons");
var _charts = require("@elastic/charts");
var _public = require("@kbn/charts-plugin/public");
var _chartsTheme = require("@kbn/charts-theme");
var _coloring = require("@kbn/coloring");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _palettes = require("@kbn/palettes");
var _react2 = require("@emotion/react");
var _format_service = require("../format_service");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_tagcloud/public/components/tagcloud_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_TAG_COUNT = 200;
const calculateWeight = (value, x1, y1, x2, y2) => (value - x1) * (y2 - x2) / (y1 - x1) + x2;
const getColor = (paletteService, activePalette, text, values, syncColors) => {
  var _paletteService$get, _activePalette$params;
  return paletteService === null || paletteService === void 0 ? void 0 : (_paletteService$get = paletteService.get(activePalette === null || activePalette === void 0 ? void 0 : activePalette.name)) === null || _paletteService$get === void 0 ? void 0 : _paletteService$get.getCategoricalColor([{
    name: text,
    rankAtDepth: values.length ? values.findIndex(name => name === text) : 0,
    totalSeriesAtDepth: values.length || 1
  }], {
    maxDepth: 1,
    totalSeries: values.length || 1,
    behindText: false,
    syncColors
  }, (_activePalette$params = activePalette === null || activePalette === void 0 ? void 0 : activePalette.params) !== null && _activePalette$params !== void 0 ? _activePalette$params : {
    colors: []
  });
};
const ORIENTATIONS = {
  [_constants.Orientation.SINGLE]: {
    endAngle: 0,
    angleCount: 360
  },
  [_constants.Orientation.RIGHT_ANGLED]: {
    endAngle: 90,
    angleCount: 2
  },
  [_constants.Orientation.MULTIPLE]: {
    endAngle: -90,
    angleCount: 12
  }
};
const TagCloudChart = ({
  visData,
  visParams,
  palettesRegistry,
  fireEvent,
  renderComplete,
  syncColors,
  overrides,
  isDarkMode
}) => {
  const [warning, setWarning] = (0, _react.useState)(false);
  const palettes = (0, _palettes.useKbnPalettes)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const {
    bucket,
    metric,
    scale,
    palette,
    showLabel,
    orientation,
    colorMapping
  } = visParams;
  const bucketFormatter = (0, _react.useMemo)(() => {
    return bucket ? (0, _format_service.getFormatService)().deserialize((0, _utils.getFormatByAccessor)(bucket, visData.columns)) : null;
  }, [bucket, visData.columns]);
  const tagCloudData = (0, _react.useMemo)(() => {
    const bucketColumn = bucket ? (0, _utils.getColumnByAccessor)(bucket, visData.columns) : null;
    const tagColumn = bucket ? bucketColumn.id : undefined;
    const metricColumn = (0, _utils.getColumnByAccessor)(metric, visData.columns).id;
    const metrics = visData.rows.map(row => row[metricColumn]);
    const values = bucket && tagColumn !== undefined ? visData.rows.map(row => row[tagColumn]) : [];
    const maxValue = Math.max(...metrics);
    const minValue = Math.min(...metrics);
    const colorFromMappingFn = getColorFromMappingFactory(tagColumn, visData.rows, palettes, isDarkMode, colorMapping);
    return visData.rows.map(row => {
      const {
        value: tagValue,
        tag
      } = tagColumn === undefined ? {
        value: undefined,
        tag: 'all'
      } : {
        value: row[tagColumn],
        tag: row[tagColumn]
      };
      return {
        text: bucketFormatter ? bucketFormatter.convert(tag, 'text') : tag,
        weight: tag === 'all' || visData.rows.length <= 1 ? 1 : calculateWeight(row[metricColumn], minValue, maxValue, 0, 1) || 0,
        color: colorFromMappingFn ? colorFromMappingFn(tagValue) : getColor(palettesRegistry, palette, tag, values, syncColors) || 'rgba(0,0,0,0)'
      };
    });
  }, [bucket, visData.columns, visData.rows, metric, palettes, isDarkMode, colorMapping, bucketFormatter, palettesRegistry, palette, syncColors]);
  (0, _react.useEffect)(() => {
    // clear warning when data changes
    if (warning) {
      setWarning(false);
    }
    // "warning" excluded from dependencies.
    // Clear warning when "tagCloudData" changes. Do not clear warning when "warning" changes.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [tagCloudData]);
  const label = bucket ? `${(0, _utils.getColumnByAccessor)(bucket, visData.columns).name} - ${(0, _utils.getColumnByAccessor)(metric, visData.columns).name}` : '';
  const onRenderChange = (0, _react.useCallback)(isRendered => {
    if (isRendered) {
      renderComplete();
    }
  }, [renderComplete]);
  const updateChart = (0, _react.useMemo)(() => (0, _lodash.throttle)(() => {
    setWarning(false);
  }, 300), []);
  const handleWordClick = (0, _react.useCallback)(elements => {
    if (!bucket) {
      return;
    }
    const termsBucketId = (0, _utils.getColumnByAccessor)(bucket, visData.columns).id;
    const clickedValue = elements[0][0].text;
    const columnIndex = visData.columns.findIndex(col => col.id === termsBucketId);
    if (columnIndex < 0) {
      return;
    }
    const rowIndex = visData.rows.findIndex(row => {
      const formattedValue = bucketFormatter ? bucketFormatter.convert(row[termsBucketId], 'text') : row[termsBucketId];
      return formattedValue === clickedValue;
    });
    if (rowIndex < 0) {
      return;
    }
    fireEvent({
      name: 'filter',
      data: {
        data: [{
          table: visData,
          column: columnIndex,
          row: rowIndex
        }]
      }
    });
  }, [bucket, bucketFormatter, fireEvent, visData]);
  if (visData.rows.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
      icon: _chartIcons.IconChartTagcloud,
      renderComplete: renderComplete,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: updateChart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 5
    }
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    css: tgcChartCss.wrapper,
    ref: resizeRef,
    "data-test-subj": "tagCloudVisualization",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, (0, _extends2.default)({
    size: "100%"
  }, (0, _chartExpressionsCommon.getOverridesFor)(overrides, 'chart'), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({
    baseTheme: chartBaseTheme,
    onElementClick: handleWordClick,
    onRenderChange: onRenderChange,
    ariaLabel: visParams.ariaLabel,
    ariaUseDefaultSummary: !visParams.ariaLabel,
    locale: _i18n.i18n.getLocale()
  }, (0, _chartExpressionsCommon.getOverridesFor)(overrides, 'settings'), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Wordcloud, {
    id: "tagCloud",
    startAngle: 0,
    endAngle: ORIENTATIONS[orientation].endAngle,
    angleCount: ORIENTATIONS[orientation].angleCount,
    padding: 5,
    fontWeight: 400,
    fontFamily: "Inter UI, sans-serif",
    fontStyle: "normal",
    minFontSize: visParams.minFontSize,
    maxFontSize: visParams.maxFontSize,
    spiral: "archimedean",
    data: tagCloudData,
    weightFn: scale === _constants.ScaleOptions.SQUARE_ROOT ? 'squareRoot' : scale,
    outOfRoomCallback: () => {
      setWarning(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 13
    }
  })), label && showLabel && /*#__PURE__*/_react.default.createElement("div", {
    css: tgcChartCss.label,
    "data-test-subj": "tagCloudLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 13
    }
  }, label), !visParams.isPreview && warning && /*#__PURE__*/_react.default.createElement("div", {
    css: tgcChartCss.warning,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "warning",
    color: "warning",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "expressionTagcloud.feedbackMessage.tooSmallContainerDescription",
      defaultMessage: "The container is too small to display the entire cloud. Tags might be cropped or omitted.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 15
    }
  })), !visParams.isPreview && tagCloudData.length > MAX_TAG_COUNT && /*#__PURE__*/_react.default.createElement("div", {
    css: tgcChartCss.warning,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "warning",
    color: "warning",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "expressionTagcloud.feedbackMessage.truncatedTagsDescription",
      defaultMessage: "The number of tags has been truncated to avoid long draw times.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 15
    }
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.TagCloudChart = TagCloudChart;
/**
 * If colorMapping is available, returns a function that accept a string or an array of strings (used in case of multi-field-key)
 * and returns a color specified in the provided mapping
 */
function getColorFromMappingFactory(tagColumn, rows, palettes, isDarkMode, colorMapping) {
  if (!colorMapping) {
    // return undefined, we will use the legacy color mapping instead
    return undefined;
  }
  return (0, _coloring.getColorFactory)(JSON.parse(colorMapping), palettes, isDarkMode, {
    type: 'categories',
    categories: (0, _chartExpressionsCommon.getColorCategories)(rows, tagColumn)
  });
}
const tgcChartCss = {
  wrapper: (0, _react2.css)({
    flex: '1 1 0',
    display: 'flex',
    flexDirection: 'column',
    // it is used for rendering at `Canvas`.
    height: '100%',
    '& text': {
      cursor: 'pointer'
    }
  }),
  label: ({
    euiTheme
  }) => (0, _react2.css)({
    width: '100%',
    textAlign: 'center',
    fontWeight: euiTheme.font.weight.bold
  }),
  warning: ({
    euiTheme
  }) => (0, _react2.css)({
    width: euiTheme.size.base
  })
};