"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldShowLegend = exports.isLegendFlat = void 0;
var _types = require("../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isLegendFlatCommon = splitChartDimension => Boolean(splitChartDimension);
const isLegendFlat = (visType, splitChartDimension) => ({
  [_types.ChartTypes.PIE]: () => isLegendFlatCommon(splitChartDimension),
  [_types.ChartTypes.DONUT]: () => isLegendFlatCommon(splitChartDimension),
  [_types.ChartTypes.TREEMAP]: () => isLegendFlatCommon(splitChartDimension),
  [_types.ChartTypes.MOSAIC]: () => isLegendFlatCommon(splitChartDimension),
  [_types.ChartTypes.WAFFLE]: () => true
})[visType]();
exports.isLegendFlat = isLegendFlat;
const showIfBuckets = bucketColumns => bucketColumns.length > 1;
const showLegendDefault = (visType, bucketColumns) => ({
  [_types.ChartTypes.PIE]: () => showIfBuckets(bucketColumns),
  [_types.ChartTypes.DONUT]: () => showIfBuckets(bucketColumns),
  [_types.ChartTypes.TREEMAP]: () => false,
  [_types.ChartTypes.MOSAIC]: () => false,
  [_types.ChartTypes.WAFFLE]: () => true
})[visType]();
const shouldShowLegend = (visType, legendDisplay, bucketColumns = []) => legendDisplay === _types.LegendDisplay.SHOW || legendDisplay === _types.LegendDisplay.DEFAULT && showLegendDefault(visType, bucketColumns);
exports.shouldShowLegend = shouldShowLegend;