"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.getPartitionVisRenderer = exports.getColumnCellValueActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/presentation-util-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _analytics = require("@kbn/analytics");
var _ebtTools = require("@kbn/ebt-tools");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _constants = require("../../common/constants");
var _types = require("../../common/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_partition_vis/public/expression_renderers/partition_vis_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = exports.strings = {
  getDisplayName: () => _i18n.i18n.translate('expressionPartitionVis.renderer.partitionVis.pie.displayName', {
    defaultMessage: 'Partition visualization'
  }),
  getHelpDescription: () => _i18n.i18n.translate('expressionPartitionVis.renderer.partitionVis.pie.helpDescription', {
    defaultMessage: 'Render pie/donut/treemap/mosaic/waffle charts'
  })
};
const LazyPartitionVisComponent = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/partition_vis_component'))));
const PartitionVisComponent = (0, _public.withSuspense)(LazyPartitionVisComponent);
const partitionVisRenderer = (0, _react2.css)({
  position: 'relative',
  width: '100%',
  height: '100%'
});

/**
 * Retrieves the compatible CELL_VALUE_TRIGGER actions indexed by column
 **/
const getColumnCellValueActions = async (visConfig, visData, getCompatibleCellValueActions) => {
  if (!Array.isArray(visConfig.dimensions.buckets) || !getCompatibleCellValueActions) {
    return [];
  }
  return Promise.all(visConfig.dimensions.buckets.reduce((acc, accessor) => {
    var _getColumnByAccessor;
    const columnMeta = (_getColumnByAccessor = (0, _utils.getColumnByAccessor)(accessor, visData.columns)) === null || _getColumnByAccessor === void 0 ? void 0 : _getColumnByAccessor.meta;
    if (columnMeta) {
      acc.push(getCompatibleCellValueActions([{
        columnMeta
      }]));
    }
    return acc;
  }, []));
};
exports.getColumnCellValueActions = getColumnCellValueActions;
const getPartitionVisRenderer = ({
  getStartDeps
}) => ({
  name: _constants.PARTITION_VIS_RENDERER_NAME,
  displayName: strings.getDisplayName(),
  help: strings.getHelpDescription(),
  reuseDomNode: true,
  render: async (domNode, {
    visConfig,
    visData,
    visType,
    syncColors,
    canNavigateToLens,
    overrides
  }, handlers) => {
    const performanceTracker = (0, _ebtTools.createPerformanceTracker)({
      type: _ebtTools.PERFORMANCE_TRACKER_TYPES.PANEL,
      subType: _constants.PARTITION_VIS_RENDERER_NAME
    });
    performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.PRE_RENDER);
    const {
      core,
      plugins
    } = getStartDeps();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const renderComplete = () => {
      performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.RENDER_COMPLETE);
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (containerType && visualizationType) {
        var _plugins$usageCollect;
        const events = [`render_${visualizationType}_${visType}`, canNavigateToLens ? `render_${visualizationType}_${visType}_convertable` : undefined].filter(event => Boolean(event));
        (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, events);
      }
      handlers.done();
    };
    const [columnCellValueActions, palettesRegistry] = await Promise.all([getColumnCellValueActions(visConfig, visData, handlers.getCompatibleCellValueActions), plugins.charts.palettes.getPalettes()]);
    const hasOpenedOnAggBasedEditor = (0, _chartExpressionsCommon.isOnAggBasedEditor)(handlers.getExecutionContext());
    const chartSizeEvent = {
      name: 'chartSize',
      data: {
        maxDimensions: {
          x: {
            value: 100,
            unit: 'percentage'
          },
          y: {
            value: 100,
            unit: 'percentage'
          }
        }
      }
    };
    handlers.event(chartSizeEvent);
    performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.RENDER_START);
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement("div", {
      css: partitionVisRenderer,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(PartitionVisComponent, {
      chartsThemeService: plugins.charts.theme,
      palettesRegistry: palettesRegistry,
      visParams: visConfig,
      visData: visData,
      visType: visConfig.isDonut ? _types.ChartTypes.DONUT : visType,
      renderComplete: renderComplete,
      fireEvent: handlers.event,
      hasCompatibleActions: handlers.hasCompatibleActions,
      interactive: handlers.isInteractive(),
      uiState: handlers.uiState,
      services: {
        data: plugins.data,
        fieldFormats: plugins.fieldFormats
      },
      syncColors: syncColors,
      columnCellValueActions: columnCellValueActions,
      overrides: overrides,
      hasOpenedOnAggBasedEditor: hasOpenedOnAggBasedEditor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 11
      }
    }))), domNode);
  }
});
exports.getPartitionVisRenderer = getPartitionVisRenderer;