"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSeriesFilters = void 0;
var _lodash = require("lodash");
var _use_series_storage = require("./use_series_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSeriesFilters = ({
  seriesId,
  series
}) => {
  var _series$filters;
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const filters = (_series$filters = series.filters) !== null && _series$filters !== void 0 ? _series$filters : [];
  const replaceFilter = ({
    field,
    values,
    notValues,
    wildcards,
    notWildcards
  }) => {
    var _filters$find;
    const currFilter = (_filters$find = filters.find(({
      field: fd
    }) => field === fd)) !== null && _filters$find !== void 0 ? _filters$find : {
      field
    };
    currFilter.notValues = notValues.length > 0 ? notValues : undefined;
    currFilter.values = values.length > 0 ? values : undefined;
    currFilter.wildcards = wildcards;
    currFilter.notWildcards = notWildcards;
    const otherFilters = filters.filter(({
      field: fd
    }) => fd !== field);
    if ((0, _lodash.concat)(values, notValues, wildcards, notWildcards).length > 0) {
      setSeries(seriesId, {
        ...series,
        filters: [...otherFilters, currFilter]
      });
    } else {
      setSeries(seriesId, {
        ...series,
        filters: otherFilters
      });
    }
  };
  const removeFilter = ({
    field,
    value,
    negate,
    isWildcard
  }) => {
    const filtersN = filters.map(filter => {
      if (filter.field === field) {
        if (negate) {
          var _filter$notValues;
          if (isWildcard) {
            var _filter$notWildcards;
            const notWildcardsN = (_filter$notWildcards = filter.notWildcards) === null || _filter$notWildcards === void 0 ? void 0 : _filter$notWildcards.filter(val => value instanceof Array ? !value.includes(val) : val !== value);
            return {
              ...filter,
              notWildcards: notWildcardsN
            };
          }
          const notValuesN = (_filter$notValues = filter.notValues) === null || _filter$notValues === void 0 ? void 0 : _filter$notValues.filter(val => value instanceof Array ? !value.includes(val) : val !== value);
          return {
            ...filter,
            notValues: notValuesN
          };
        } else {
          var _filter$values;
          if (isWildcard) {
            var _filter$wildcards;
            const wildcardsN = (_filter$wildcards = filter.wildcards) === null || _filter$wildcards === void 0 ? void 0 : _filter$wildcards.filter(val => value instanceof Array ? !value.includes(val) : val !== value);
            return {
              ...filter,
              wildcards: wildcardsN
            };
          }
          const valuesN = (_filter$values = filter.values) === null || _filter$values === void 0 ? void 0 : _filter$values.filter(val => value instanceof Array ? !value.includes(val) : val !== value);
          return {
            ...filter,
            values: valuesN
          };
        }
      }
      return filter;
    }).filter(({
      values = [],
      notValues = [],
      wildcards = [],
      notWildcards = []
    }) => values.length > 0 || notValues.length > 0 || wildcards.length > 0 || notWildcards.length > 0);
    setSeries(seriesId, {
      ...series,
      filters: filtersN
    });
  };
  const addFilter = ({
    field,
    value,
    negate
  }) => {
    const currFilter = {
      field
    };
    if (negate) {
      currFilter.notValues = value instanceof Array ? value : [value];
    } else {
      currFilter.values = value instanceof Array ? value : [value];
    }
    if (filters.length === 0) {
      setSeries(seriesId, {
        ...series,
        filters: [currFilter]
      });
    } else {
      setSeries(seriesId, {
        ...series,
        filters: [currFilter, ...filters.filter(ft => ft.field !== field)]
      });
    }
  };
  const updateFilter = ({
    field,
    value,
    negate,
    wildcards
  }) => {
    var _filters$find2, _currFilter$notValues, _currFilter$values;
    const currFilter = (_filters$find2 = filters.find(({
      field: fd
    }) => field === fd)) !== null && _filters$find2 !== void 0 ? _filters$find2 : {
      field
    };
    const currNotValues = (_currFilter$notValues = currFilter.notValues) !== null && _currFilter$notValues !== void 0 ? _currFilter$notValues : [];
    const currValues = (_currFilter$values = currFilter.values) !== null && _currFilter$values !== void 0 ? _currFilter$values : [];
    const notValues = currNotValues.filter(val => value instanceof Array ? !value.includes(val) : val !== value);
    const values = currValues.filter(val => value instanceof Array ? !value.includes(val) : val !== value);
    if (negate) {
      if (value instanceof Array) {
        notValues.push(...value);
      } else {
        notValues.push(value);
      }
    } else {
      if (value instanceof Array) {
        values.push(...value);
      } else {
        values.push(value);
      }
    }
    replaceFilter({
      field,
      values,
      notValues,
      wildcards
    });
  };
  const setFilter = ({
    field,
    value,
    negate,
    wildcards
  }) => {
    const currFilter = filters.find(({
      field: fd
    }) => field === fd);
    if (!currFilter) {
      addFilter({
        field,
        value,
        negate,
        wildcards
      });
    } else {
      updateFilter({
        field,
        value,
        negate,
        wildcards
      });
    }
  };
  const setFiltersWildcard = ({
    field,
    wildcards
  }) => {
    let currFilter = filters.find(({
      field: fd
    }) => field === fd);
    if (!currFilter) {
      currFilter = {
        field,
        wildcards
      };
      if (filters.length === 0) {
        setSeries(seriesId, {
          ...series,
          filters: [currFilter]
        });
      } else {
        setSeries(seriesId, {
          ...series,
          filters: [currFilter, ...filters.filter(ft => ft.field !== field)]
        });
      }
    } else {
      var _currFilter$values2, _currFilter$notValues2;
      replaceFilter({
        field,
        values: (_currFilter$values2 = currFilter.values) !== null && _currFilter$values2 !== void 0 ? _currFilter$values2 : [],
        notValues: (_currFilter$notValues2 = currFilter.notValues) !== null && _currFilter$notValues2 !== void 0 ? _currFilter$notValues2 : [],
        wildcards
      });
    }
  };
  const invertFilter = ({
    field,
    value,
    negate
  }) => {
    updateFilter({
      field,
      value,
      negate: !negate
    });
  };
  return {
    invertFilter,
    setFilter,
    removeFilter,
    replaceFilter,
    setFiltersWildcard
  };
};
exports.useSeriesFilters = useSeriesFilters;