"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMobileKPIConfig = getMobileKPIConfig;
var _constants = require("../constants");
var _utils = require("../utils");
var _elasticsearch_fieldnames = require("../constants/elasticsearch_fieldnames");
var _labels = require("../constants/labels");
var _mobile_fields = require("./mobile_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getMobileKPIConfig({
  dataView
}) {
  return {
    reportType: _constants.ReportTypes.KPI,
    defaultSeriesType: 'line',
    seriesTypes: ['line', 'bar', 'area'],
    xAxisColumn: {
      sourceField: '@timestamp'
    },
    yAxisColumns: [{
      sourceField: _constants.REPORT_METRIC_FIELD,
      operationType: 'median'
    }],
    hasOperationType: true,
    filterFields: [...Object.keys(_mobile_fields.MobileFields), _constants.LABEL_FIELDS_FILTER],
    breakdownFields: Object.keys(_mobile_fields.MobileFields),
    baseFilters: [...(0, _utils.buildPhrasesFilter)('agent.name', ['iOS/swift', 'open-telemetry/swift'], dataView)],
    labels: {
      ..._constants.FieldLabels,
      ..._mobile_fields.MobileFields,
      [_elasticsearch_fieldnames.TRANSACTION_DURATION]: _labels.RESPONSE_LATENCY,
      [_elasticsearch_fieldnames.SERVICE_NAME]: _labels.MOBILE_APP,
      [_elasticsearch_fieldnames.METRIC_SYSTEM_MEMORY_USAGE]: _labels.SYSTEM_MEMORY_USAGE,
      [_elasticsearch_fieldnames.METRIC_SYSTEM_CPU_USAGE]: _labels.CPU_USAGE
    },
    definitionFields: [_elasticsearch_fieldnames.SERVICE_NAME, _elasticsearch_fieldnames.SERVICE_ENVIRONMENT],
    metricOptions: [{
      label: _labels.RESPONSE_LATENCY,
      field: _elasticsearch_fieldnames.TRANSACTION_DURATION,
      id: _elasticsearch_fieldnames.TRANSACTION_DURATION,
      columnType: _constants.OPERATION_COLUMN
    }, {
      field: _constants.RECORDS_FIELD,
      id: _constants.RECORDS_FIELD,
      label: _labels.TRANSACTIONS_PER_MINUTE,
      columnFilters: [{
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.PROCESSOR_EVENT}: transaction`
      }],
      timeScale: 'm'
    }, {
      label: _labels.SYSTEM_MEMORY_USAGE,
      field: _elasticsearch_fieldnames.METRIC_SYSTEM_MEMORY_USAGE,
      id: _elasticsearch_fieldnames.METRIC_SYSTEM_MEMORY_USAGE,
      columnType: _constants.OPERATION_COLUMN,
      columnFilters: [{
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.PROCESSOR_EVENT}: metric`
      }]
    }, {
      label: _labels.CPU_USAGE,
      field: _elasticsearch_fieldnames.METRIC_SYSTEM_CPU_USAGE,
      id: _elasticsearch_fieldnames.METRIC_SYSTEM_CPU_USAGE,
      columnType: _constants.OPERATION_COLUMN,
      columnFilters: [{
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.PROCESSOR_EVENT}: metric`
      }]
    }]
  };
}