"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _complete_items = require("../../complete_items");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _expressions = require("../../../definitions/utils/expressions");
var _types = require("../../types");
var _functions = require("../../../definitions/utils/autocomplete/functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  if (!(callbacks !== null && callbacks !== void 0 && callbacks.getByType)) {
    return [];
  }
  const innerText = query.substring(0, cursorPosition);
  const expressionRoot = command.args[0];
  const suggestions = await (0, _helpers.suggestForExpression)({
    innerText,
    getColumnsByType: callbacks.getByType,
    expressionRoot,
    location: _types.Location.WHERE,
    preferredExpressionType: 'boolean',
    context,
    hasMinimumLicenseRequired: callbacks === null || callbacks === void 0 ? void 0 : callbacks.hasMinimumLicenseRequired,
    activeProduct: context === null || context === void 0 ? void 0 : context.activeProduct
  });
  const functionsSpecificSuggestions = await (0, _functions.getInsideFunctionsSuggestions)(innerText, cursorPosition, callbacks, context);
  if (functionsSpecificSuggestions) {
    return functionsSpecificSuggestions;
  }

  // Is this a complete boolean expression?
  // If so, we can call it done and suggest a pipe
  const expressionType = (0, _expressions.getExpressionType)(expressionRoot, context === null || context === void 0 ? void 0 : context.columns);
  if (expressionType === 'boolean' && (0, _expressions.isExpressionComplete)(expressionType, innerText)) {
    suggestions.push(_complete_items.pipeCompleteItem);
  }
  return suggestions;
}