"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isExistsFilter = exports.getExistsFilterField = exports.buildSimpleExistFilter = exports.buildExistsFilter = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @public */

/**
 * @param filter
 * @returns `true` if a filter is an `ExistsFilter`
 *
 * @public
 */
const isExistsFilter = filter => (0, _lodash.has)(filter, 'query.exists');

/**
 * @internal
 */
exports.isExistsFilter = isExistsFilter;
const getExistsFilterField = filter => {
  return filter.query.exists && filter.query.exists.field;
};

/**
 * Builds an `ExistsFilter`
 * @param field field to validate the existence of
 * @param indexPattern index pattern to look for the field in
 * @returns An `ExistsFilter`
 *
 * @public
 */
exports.getExistsFilterField = getExistsFilterField;
const buildExistsFilter = (field, indexPattern) => {
  return {
    meta: {
      index: indexPattern.id
    },
    query: {
      exists: {
        field: field.name
      }
    }
  };
};
exports.buildExistsFilter = buildExistsFilter;
const buildSimpleExistFilter = (fieldName, dataViewId) => {
  return {
    meta: {
      index: dataViewId
    },
    query: {
      exists: {
        field: fieldName
      }
    }
  };
};
exports.buildSimpleExistFilter = buildSimpleExistFilter;