"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAndInstallILMPolicies = createAndInstallILMPolicies;
exports.deleteILMPolicies = deleteILMPolicies;
exports.deleteILMPolicy = deleteILMPolicy;
exports.getILMPoliciesStatus = getILMPoliciesStatus;
var _constants_entities = require("../../../common/constants_entities");
var _history_ilm_policy = require("./ilm_policies/history_ilm_policy");
var _retry = require("./helpers/retry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createAndInstallILMPolicies(esClient) {
  const historyPolicy = (0, _history_ilm_policy.generateEntitiesHistoryILMPolicy)();
  await esClient.ilm.putLifecycle(historyPolicy);
}
async function getILMPoliciesStatus(esClient) {
  const policies = [];
  await esClient.ilm.getLifecycle({
    name: _constants_entities.ENTITY_HISTORY_ILM_POLICY
  });
  policies.push({
    type: 'ilm_policy',
    id: _constants_entities.ENTITY_HISTORY_ILM_POLICY
  });
  return policies;
}
async function deleteILMPolicy(esClient, name, logger) {
  try {
    await (0, _retry.retryTransientEsErrors)(() => esClient.ilm.deleteLifecycle({
      name
    }, {
      ignore: [404]
    }), {
      logger
    });
  } catch (error) {
    logger.error(`Error deleting entity manager index ilm policy: ${error.message}`);
    throw error;
  }
}
async function deleteILMPolicies(esClient, logger) {
  await deleteILMPolicy(esClient, _constants_entities.ENTITY_HISTORY_ILM_POLICY, logger);
}