"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteIndexPipelines = void 0;
var _ml_inference_pipeline_utils = require("../../utils/ml_inference_pipeline_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteIndexPipelines = async (client, indexName) => {
  const deleted = [];
  const promises = [client.asCurrentUser.ingest.deletePipeline({
    id: indexName
  }).then(() => deleted.push(indexName)), client.asCurrentUser.ingest.deletePipeline({
    id: (0, _ml_inference_pipeline_utils.getInferencePipelineNameFromIndexName)(indexName)
  }).then(() => deleted.push((0, _ml_inference_pipeline_utils.getInferencePipelineNameFromIndexName)(indexName))), client.asCurrentUser.ingest.deletePipeline({
    id: `${indexName}@custom`
  }).then(() => deleted.push(`${indexName}@custom`))];
  await Promise.allSettled(promises);
  return {
    deleted
  };
};
exports.deleteIndexPipelines = deleteIndexPipelines;