"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.analyticsEventsExist = void 0;
var _identify_exceptions = require("../../utils/identify_exceptions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const analyticsEventsExist = async (client, datastreamName) => {
  try {
    const response = await client.asCurrentUser.count({
      index: datastreamName
    });
    return response.count > 0;
  } catch (error) {
    if ((0, _identify_exceptions.isIndexNotFoundException)(error)) {
      return false;
    }
    throw error;
  }
};
exports.analyticsEventsExist = analyticsEventsExist;