"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/search-api-panels/constants");
var _constants2 = require("../common/constants");
var _locators = require("../common/locators");
var _licensing = require("../common/utils/licensing");
var _routes = require("./applications/applications/routes");
var _routes2 = require("./applications/enterprise_search_content/routes");
var _doc_links = require("./applications/shared/doc_links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const contentLinks = [{
  id: 'connectors',
  path: `/${_routes2.CONNECTORS_PATH}`,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.navigation.contentConnectorsLinkLabel', {
    defaultMessage: 'Connectors'
  }),
  visibleIn: ['globalSearch']
}, {
  id: 'webCrawlers',
  path: `/${_routes2.CRAWLERS_PATH}`,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.navigation.contentWebcrawlersLinkLabel', {
    defaultMessage: 'Web Crawlers'
  }),
  visibleIn: ['globalSearch']
}];
const applicationsLinks = [{
  id: 'searchApplications',
  path: `/${_routes.SEARCH_APPLICATIONS_PATH}`,
  title: _constants2.SEARCH_APPS_TITLE,
  visibleIn: []
}];
class EnterpriseSearchPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "data", {});
    (0, _defineProperty2.default)(this, "enterpriseLicenseAppUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "esConfig", void 0);
    (0, _defineProperty2.default)(this, "hasInitialized", false);
    (0, _defineProperty2.default)(this, "isSidebarEnabled", true);
    (0, _defineProperty2.default)(this, "licenseSubscription", void 0);
    (0, _defineProperty2.default)(this, "sideNavDynamicItems$", new _rxjs.BehaviorSubject({}));
    (0, _defineProperty2.default)(this, "updateSideNavDefinition", items => {
      this.sideNavDynamicItems$.next({
        ...this.sideNavDynamicItems$.getValue(),
        ...items
      });
    });
    this.config = initializerContext.config.get();
    this.esConfig = {
      elasticsearch_host: _constants.ELASTICSEARCH_URL_PLACEHOLDER
    };
  }
  setup(core, plugins) {
    const {
      cloud,
      share
    } = plugins;
    core.application.register({
      appRoute: _constants2.ENTERPRISE_SEARCH_HOME_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.ENTERPRISE_SEARCH_HOME_PLUGIN.LOGO,
      id: _constants2.ENTERPRISE_SEARCH_HOME_PLUGIN.ID,
      mount: async () => {
        const [coreStart] = await core.getStartServices();
        coreStart.application.navigateToApp(_constants2.SEARCH_HOMEPAGE);
        return () => {};
      },
      order: 0,
      title: _constants2.ENTERPRISE_SEARCH_HOME_PLUGIN.NAV_TITLE,
      visibleIn: ['home', 'kibanaOverview']
    });
    core.application.register({
      appRoute: _constants2.ENTERPRISE_SEARCH_DATA_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      deepLinks: contentLinks,
      euiIconType: _constants2.ENTERPRISE_SEARCH_DATA_PLUGIN.LOGO,
      id: _constants2.ENTERPRISE_SEARCH_DATA_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.ENTERPRISE_SEARCH_DATA_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          EnterpriseSearchContent
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/enterprise_search_content')));
        return renderApp(EnterpriseSearchContent, kibanaDeps, pluginData);
      },
      order: 1,
      title: _constants2.ENTERPRISE_SEARCH_DATA_PLUGIN.NAV_TITLE,
      visibleIn: []
    });
    core.application.register({
      appRoute: _constants2.APPLICATIONS_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      deepLinks: applicationsLinks,
      euiIconType: _constants2.APPLICATIONS_PLUGIN.LOGO,
      id: _constants2.APPLICATIONS_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.ENTERPRISE_SEARCH_DATA_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          Applications
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/applications')));
        return renderApp(Applications, kibanaDeps, pluginData);
      },
      title: _constants2.APPLICATIONS_PLUGIN.NAV_TITLE,
      visibleIn: []
    });
    core.application.register({
      appRoute: _constants2.ANALYTICS_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.ENTERPRISE_SEARCH_HOME_PLUGIN.LOGO,
      id: _constants2.ANALYTICS_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.ANALYTICS_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          Analytics
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/analytics')));
        return renderApp(Analytics, kibanaDeps, pluginData);
      },
      title: _constants2.ANALYTICS_PLUGIN.NAME,
      visibleIn: []
    });
    (0, _locators.registerLocators)(share);
    core.application.register({
      appRoute: '/app/enterprise_search',
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      id: 'enterpriseSearchRedirect',
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          ApplicationRedirect
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/enterprise_search_redirect')));
        return renderApp(ApplicationRedirect, kibanaDeps, pluginData);
      },
      title: 'EnterpriseSearchRedirect',
      visibleIn: []
    });
    if (plugins.home) {
      plugins.home.featureCatalogue.registerSolution({
        description: _constants2.ENTERPRISE_SEARCH_HOME_PLUGIN.DESCRIPTION,
        icon: 'logoElasticsearch',
        id: _constants2.ENTERPRISE_SEARCH_HOME_PLUGIN.ID,
        order: 100,
        path: _constants2.ENTERPRISE_SEARCH_HOME_PLUGIN.URL,
        title: _constants2.SEARCH_PRODUCT_NAME
      });
      plugins.home.featureCatalogue.register({
        category: 'data',
        description: _constants2.ANALYTICS_PLUGIN.DESCRIPTION,
        icon: 'appAnalytics',
        id: _constants2.ANALYTICS_PLUGIN.ID,
        path: _constants2.ANALYTICS_PLUGIN.URL,
        showOnHomePage: false,
        title: _constants2.ANALYTICS_PLUGIN.NAME
      });
    }
  }
  start(core, plugins) {
    var _plugins$licensing;
    // This must be called here in start() and not in `applications/index.tsx` to prevent loading
    // race conditions with our apps' `routes.ts` being initialized before `renderApp()`
    _doc_links.docLinks.setDocLinks(core.docLinks);
    Promise.resolve().then(() => _interopRequireWildcard(require('./navigation_tree'))).then(({
      getNavigationTreeDefinition
    }) => {
      return plugins.navigation.addSolutionNavigation(getNavigationTreeDefinition({
        dynamicItems$: this.sideNavDynamicItems$
      }));
    });
    this.licenseSubscription = (_plugins$licensing = plugins.licensing) === null || _plugins$licensing === void 0 ? void 0 : _plugins$licensing.license$.subscribe(license => {
      if ((0, _licensing.hasEnterpriseLicense)(license)) {
        this.enterpriseLicenseAppUpdater$.next(() => ({
          status: _public.AppStatus.accessible
        }));
      } else {
        this.enterpriseLicenseAppUpdater$.next(() => ({
          status: _public.AppStatus.inaccessible
        }));
      }
    });

    // Return empty start contract rather than void in order for plugins
    // that depend on the enterprise search plugin to determine whether it is enabled or not
    return {};
  }
  stop() {
    if (this.licenseSubscription) {
      this.licenseSubscription.unsubscribe();
      this.licenseSubscription = undefined;
    }
  }
  async getInitialData(http) {
    try {
      this.esConfig = await http.get('/internal/enterprise_search/es_config');
    } catch {
      this.esConfig = {
        elasticsearch_host: _constants.ELASTICSEARCH_URL_PLACEHOLDER
      };
    }
    if (this.hasInitialized) return; // We've already made an initial call

    try {
      this.data = await http.get('/internal/enterprise_search/config_data');
      this.hasInitialized = true;
    } catch (e) {
      this.data.errorConnectingMessage = `${e.response.status} ${e.message}`;
    }
  }
  async getKibanaDeps(core, params, cloudSetup) {
    // Helper for using start dependencies on mount (instead of setup dependencies)
    // and for grouping Kibana-related args together (vs. plugin-specific args)
    const [coreStart, pluginsStart] = await core.getStartServices();
    const cloud = cloudSetup && pluginsStart.cloud ? {
      ...cloudSetup,
      ...pluginsStart.cloud
    } : undefined;
    const plugins = {
      ...pluginsStart,
      cloud
    };
    const chromeStyle = await (0, _rxjs.firstValueFrom)(coreStart.chrome.getChromeStyle$());
    this.isSidebarEnabled = chromeStyle === 'classic';
    coreStart.chrome.getChromeStyle$().subscribe(style => {
      this.isSidebarEnabled = style === 'classic';
    });
    return {
      core: coreStart,
      isSidebarEnabled: this.isSidebarEnabled,
      params,
      plugins,
      updateSideNavDefinition: this.updateSideNavDefinition.bind(this)
    };
  }
  getPluginData() {
    // Small helper for grouping plugin data related args together
    return {
      config: this.config,
      data: this.data,
      esConfig: this.esConfig,
      isSidebarEnabled: this.isSidebarEnabled
    };
  }
}
exports.EnterpriseSearchPlugin = EnterpriseSearchPlugin;