"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloudDetails = void 0;
var _react = require("react");
var _kea = require("kea");
var _kibana = require("../kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCloudDetails = () => {
  const {
    cloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const [elasticsearchUrl, setElasticsearchUrl] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    cloud === null || cloud === void 0 ? void 0 : cloud.fetchElasticsearchConfig().then(config => {
      setElasticsearchUrl(config.elasticsearchUrl);
    });
  }, [cloud]);
  return {
    cloudId: cloud === null || cloud === void 0 ? void 0 : cloud.cloudId,
    deploymentUrl: cloud === null || cloud === void 0 ? void 0 : cloud.deploymentUrl,
    elasticsearchUrl,
    kibanaUrl: cloud === null || cloud === void 0 ? void 0 : cloud.kibanaUrl
  };
};
exports.useCloudDetails = useCloudDetails;