"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchDocumentsApiLogic = exports.searchDocuments = void 0;
var _searchIndexDocuments = require("@kbn/search-index-documents");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchDocuments = async ({
  docsPerPage,
  indexName,
  pagination,
  query: searchQuery
}) => {
  var _response$results, _response$results$_me, _response$results2;
  const newIndexName = encodeURIComponent(indexName);
  const route = `/internal/enterprise_search/indices/${newIndexName}/search`;
  const query = {
    page: pagination.pageIndex,
    size: docsPerPage || pagination.pageSize
  };
  const response = await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify({
      searchQuery
    }),
    query
  });
  return {
    meta: (0, _searchIndexDocuments.pageToPagination)((_response$results = response.results) === null || _response$results === void 0 ? void 0 : (_response$results$_me = _response$results._meta) === null || _response$results$_me === void 0 ? void 0 : _response$results$_me.page),
    results: (_response$results2 = response.results) === null || _response$results2 === void 0 ? void 0 : _response$results2.data
  };
};
exports.searchDocuments = searchDocuments;
const searchDocumentsApiLogic = indexName => (0, _create_api_logic.createApiLogic)(['search_documents_api_logic', indexName], searchDocuments);
exports.searchDocumentsApiLogic = searchDocumentsApiLogic;