"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.putConnectorFiltering = exports.ConnectorFilteringApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const putConnectorFiltering = async ({
  connectorId
}) => {
  const route = `/internal/enterprise_search/connectors/${connectorId}/filtering`;
  return await _http.HttpLogic.values.http.put(route);
};
exports.putConnectorFiltering = putConnectorFiltering;
const ConnectorFilteringApiLogic = exports.ConnectorFilteringApiLogic = (0, _create_api_logic.createApiLogic)(['content', 'connector_filtering_api_logic'], putConnectorFiltering, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.filtering.successToastRules.title', {
    defaultMessage: 'Sync rules updated'
  })
});