"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cancelSync = exports.CancelSyncApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cancelSync = async ({
  syncJobId
}) => {
  const route = `/internal/enterprise_search/connectors/${syncJobId}/cancel_sync`;
  return await _http.HttpLogic.values.http.put(route);
};
exports.cancelSync = cancelSync;
const CancelSyncApiLogic = exports.CancelSyncApiLogic = (0, _create_api_logic.createApiLogic)(['cancel_sync_api_logic'], cancelSync, {
  showErrorFlash: true,
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.cancelSync.successMessage', {
    defaultMessage: 'Successfully canceled sync'
  })
});