"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationsListTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../shared/constants");
var _encode_path_params = require("../../../../../shared/encode_path_params");
var _formatted_date_time = require("../../../../../shared/formatted_date_time");
var _kibana = require("../../../../../shared/kibana");
var _page_to_pagination = require("../../../../../shared/pagination/page_to_pagination");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _telemetry_logic = require("../../../../../shared/telemetry/telemetry_logic");
var _routes = require("../../../../routes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_applications/components/tables/search_applications_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SearchApplicationsListTable = ({
  searchApplications,
  isLoading,
  meta,
  onChange,
  onDelete,
  viewSearchApplicationIndices
}) => {
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    sendEnterpriseSearchTelemetry
  } = (0, _kea.useActions)(_telemetry_logic.TelemetryLogic);
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.table.column.name', {
      defaultMessage: 'Search application name'
    }),
    mobileOptions: {
      header: true,
      enlarge: true,
      width: '100%'
    },
    render: name => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      "data-test-subj": "search-application-link",
      "data-telemetry-id": "entSearchApplications-table-viewSearchApplication",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_PATH, {
        searchApplicationName: name
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, name),
    truncateText: true,
    width: '30%'
  }, {
    field: 'updated_at_millis',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.table.column.lastUpdated', {
      defaultMessage: 'Last updated'
    }),
    dataType: 'number',
    render: dateString => /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
      date: new Date(dateString),
      hideTime: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 39
      }
    })
  }, {
    field: 'indices',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.table.column.indices', {
      defaultMessage: 'Indices'
    }),
    align: 'right',
    render: (indices, searchApplication) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      "data-test-subj": "searchApplicationsListTableIndicesFlyoutButton",
      "data-telemetry-id": "entSearchApplications-table-viewSearchApplicationIndices",
      onClick: () => viewSearchApplicationIndices(searchApplication.name),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.searchApplications.list.table.column.view.indices",
      defaultMessage: "{indicesCount, number} {indicesCount, plural, one {index} other {indices}}",
      values: {
        indicesCount: indices.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    }))
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.table.column.actions', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: _constants.MANAGE_BUTTON_LABEL,
      description: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.table.column.actions.view.buttonDescription', {
        defaultMessage: 'View this search application'
      }),
      type: 'icon',
      icon: 'eye',
      onClick: searchApplication => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_PATH, {
        searchApplicationName: searchApplication.name
      }))
    }, {
      color: 'danger',
      description: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.table.column.action.delete.buttonDescription', {
        defaultMessage: 'Delete this search application'
      }),
      type: 'icon',
      icon: 'trash',
      isPrimary: false,
      name: () => _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.table.column.actions.deleteSearchApplicationLabel', {
        defaultMessage: 'Delete this search application'
      }),
      onClick: searchApplication => {
        onDelete(searchApplication);
        sendEnterpriseSearchTelemetry({
          action: 'clicked',
          metric: 'entSearchApplications-table-deleteSearchApplication'
        });
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: searchApplications,
    columns: columns,
    pagination: {
      ...(0, _page_to_pagination.pageToPagination)(meta),
      showPerPageOptions: false
    },
    onChange: onChange,
    loading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 5
    }
  });
};
exports.SearchApplicationsListTable = SearchApplicationsListTable;