"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnhancementsRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EnhancementsRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "registry", new Map());
    (0, _defineProperty2.default)(this, "registerEnhancement", enhancement => {
      if (this.registry.has(enhancement.id)) {
        throw new Error(`enhancement with id ${enhancement.id} already exists in the registry`);
      }
      this.registry.set(enhancement.id, {
        id: enhancement.id,
        telemetry: enhancement.telemetry || ((state, stats) => stats),
        inject: enhancement.inject || _lodash.identity,
        extract: enhancement.extract || (state => {
          return {
            state,
            references: []
          };
        }),
        migrations: enhancement.migrations || {}
      });
    });
    (0, _defineProperty2.default)(this, "getEnhancements", () => {
      return Array.from(this.registry.values());
    });
    (0, _defineProperty2.default)(this, "getEnhancement", id => {
      return this.registry.get(id) || {
        id: 'unknown',
        telemetry: (state, stats) => stats,
        inject: _lodash.identity,
        extract: state => {
          return {
            state,
            references: []
          };
        },
        migrations: {}
      };
    });
    /**
     * extracts references from enhancements state
     */
    (0, _defineProperty2.default)(this, "transformIn", enhancementsState => {
      const outputEnhancementsState = {};
      const extractedReferences = [];
      Object.keys(enhancementsState).forEach(key => {
        if (!enhancementsState[key]) return;
        const enhancementStateManger = this.getEnhancement(key);
        const {
          state,
          references
        } = enhancementStateManger ? enhancementStateManger.extract(enhancementsState[key]) : {
          state: enhancementsState[key],
          references: []
        };
        outputEnhancementsState[key] = state;
        extractedReferences.push(...references);
      });
      return {
        enhancementsState: outputEnhancementsState,
        enhancementsReferences: extractedReferences
      };
    });
    /**
     * Injects enhancements state with references
     */
    (0, _defineProperty2.default)(this, "transformOut", (enhancementsState, references) => {
      const outputEnhancementsState = {};
      Object.keys(enhancementsState).forEach(key => {
        if (!enhancementsState[key]) return;
        const enhancementStateManger = this.getEnhancement(key);
        outputEnhancementsState[key] = enhancementStateManger ? enhancementStateManger.inject(enhancementsState[key], references) : enhancementsState[key];
      });
      return outputEnhancementsState;
    });
  }
}
exports.EnhancementsRegistry = EnhancementsRegistry;