"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConversationWithNewMessage = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _messages = require("@langchain/core/messages");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches a conversation by its ID and appends new messages to it.
 * If the conversation does not exist, it returns the new messages as is.
 * If the conversation exists, it appends the new messages to the existing conversation.
 * The returned messages are anonymized.
 */
const getConversationWithNewMessage = async params => {
  var _existingConversation4;
  const {
    conversationsDataClient,
    conversationId
  } = params;
  if (!conversationsDataClient || !conversationId) {
    params.logger.debug('No conversationsDataClient or conversationId provided, returning empty messages array');
    return params.newMessages;
  }
  const existingConversation = await conversationsDataClient.getConversation({
    id: conversationId
  });
  if (!existingConversation) {
    params.logger.debug(`No conversation found for id: ${conversationId}`);
    return params.newMessages;
  }
  const updatedConversation = await conversationsDataClient.appendConversationMessages({
    existingConversation,
    messages: params.newMessages.map(newMessage => {
      var _existingConversation, _existingConversation2, _existingConversation3;
      const role = (0, _messages._isMessageFieldWithRole)(newMessage) ? newMessage.role : 'user';
      return {
        content: (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
          messageContent: newMessage.text,
          replacements: params.replacements
        }),
        role,
        user: (_existingConversation = existingConversation.createdBy) !== null && _existingConversation !== void 0 ? _existingConversation : ((_existingConversation2 = existingConversation.users) === null || _existingConversation2 === void 0 ? void 0 : _existingConversation2.length) === 1 ? // no createdBy indicates legacy conversation, assign the sole user in the user list
        (_existingConversation3 = existingConversation.users) === null || _existingConversation3 === void 0 ? void 0 : _existingConversation3[0] : undefined,
        timestamp: new Date().toISOString()
      };
    })
  });
  if (!updatedConversation) {
    params.logger.debug('Conversation was not updated with new messages');
  }

  // Anonymized conversation
  const conversationLangChainMessages = (0, _helpers.getLangChainMessages)((_existingConversation4 = existingConversation.messages) !== null && _existingConversation4 !== void 0 ? _existingConversation4 : []);
  // Anonymized new messages
  const newLangChainMessages = params.newMessages;

  // Combine both, return the whole conversation with new messages, all anonymized
  return [...conversationLangChainMessages, ...newLangChainMessages];
};
exports.getConversationWithNewMessage = getConversationWithNewMessage;