"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefendInsightsGraphInputOverrides = void 0;
var _fp = require("lodash/fp");
var _example_input = require("../../example_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Parses input from an LangSmith dataset example to get the graph input overrides
 */
const getDefendInsightsGraphInputOverrides = inputs => {
  var _ExampleDefendInsight;
  const validatedInput = (_ExampleDefendInsight = _example_input.ExampleDefendInsightsInputWithOverrides.safeParse(inputs).data) !== null && _ExampleDefendInsight !== void 0 ? _ExampleDefendInsight : {}; // safeParse removes unknown properties

  const {
    overrides
  } = validatedInput;

  // return all overrides at the root level:
  return {
    // pick extracts just the anonymizedDocuments and replacements from the root level of the input,
    // and only adds the anonymizedDocuments key if it exists in the input
    ...(0, _fp.pick)('anonymizedDocuments', validatedInput),
    ...(0, _fp.pick)('replacements', validatedInput),
    ...overrides // bring all other overrides to the root level
  };
};
exports.getDefendInsightsGraphInputOverrides = getDefendInsightsGraphInputOverrides;