"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SECURITY_APP_PATH = exports.ATTACK_DISCOVERY_ALERTS_CONTEXT = exports.ATTACK_DISCOVERY_ALERTS_AAD_CONFIG = void 0;
var _fields = require("./fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_APP_PATH = exports.SECURITY_APP_PATH = `/app/security`;
const ATTACK_DISCOVERY_ALERTS_CONTEXT = exports.ATTACK_DISCOVERY_ALERTS_CONTEXT = 'security.attack.discovery';
const ATTACK_DISCOVERY_ALERTS_AAD_CONFIG = exports.ATTACK_DISCOVERY_ALERTS_AAD_CONFIG = {
  context: ATTACK_DISCOVERY_ALERTS_CONTEXT,
  mappings: {
    fieldMap: _fields.attackDiscoveryAlertFieldMap
  },
  isSpaceAware: true,
  shouldWrite: true,
  useEcs: true
};