"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformToUpdateScheme = exports.appendConversationMessages = void 0;
var _uuid = require("uuid");
var _transforms = require("./transforms");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const appendConversationMessages = async ({
  dataWriter,
  logger,
  existingConversation,
  messages,
  authenticatedUser
}) => {
  var _existingConversation, _transformESToConvers;
  const updatedAt = new Date().toISOString();
  const params = transformToUpdateScheme(updatedAt, [...((_existingConversation = existingConversation.messages) !== null && _existingConversation !== void 0 ? _existingConversation : []), ...messages], existingConversation);
  const {
    errors,
    docs_updated: docsUpdated
  } = await dataWriter.bulk({
    documentsToUpdate: [params],
    getUpdateScript: document => (0, _helpers.getUpdateScript)({
      conversation: document
    }),
    authenticatedUser
  });
  if (errors && errors.length > 0) {
    logger.error(`Error appending conversation messages: ${errors.map(err => err.message)} for conversation by ID: ${existingConversation.id}`);
    return null;
  }
  const updatedConversation = (_transformESToConvers = (0, _transforms.transformESToConversations)(docsUpdated)) === null || _transformESToConvers === void 0 ? void 0 : _transformESToConvers[0];
  return updatedConversation;
};
exports.appendConversationMessages = appendConversationMessages;
const transformToUpdateScheme = (updatedAt, messages, existingConversation) => {
  return {
    id: existingConversation.id,
    updated_at: updatedAt,
    // Preserve all existing conversation fields
    ...(existingConversation.title ? {
      title: existingConversation.title
    } : {}),
    ...(existingConversation.apiConfig ? {
      api_config: {
        action_type_id: existingConversation.apiConfig.actionTypeId,
        connector_id: existingConversation.apiConfig.connectorId,
        default_system_prompt_id: existingConversation.apiConfig.defaultSystemPromptId,
        model: existingConversation.apiConfig.model,
        provider: existingConversation.apiConfig.provider
      }
    } : {}),
    ...(existingConversation.excludeFromLastConversationStorage != null ? {
      exclude_from_last_conversation_storage: existingConversation.excludeFromLastConversationStorage
    } : {}),
    ...(existingConversation.replacements ? {
      replacements: Object.keys(existingConversation.replacements).map(key => {
        var _existingConversation2, _existingConversation3;
        return {
          uuid: key,
          value: (_existingConversation2 = (_existingConversation3 = existingConversation.replacements) === null || _existingConversation3 === void 0 ? void 0 : _existingConversation3[key]) !== null && _existingConversation2 !== void 0 ? _existingConversation2 : ''
        };
      })
    } : {}),
    // Update messages with the new combined list
    messages: messages === null || messages === void 0 ? void 0 : messages.map(message => {
      var _message$id;
      return {
        '@timestamp': message.timestamp,
        id: (_message$id = message.id) !== null && _message$id !== void 0 ? _message$id : (0, _uuid.v4)(),
        content: message.content,
        is_error: message.isError,
        reader: message.reader,
        role: message.role,
        user: message.user,
        ...(message.metadata ? {
          metadata: {
            ...(message.metadata.contentReferences ? {
              content_references: message.metadata.contentReferences
            } : {})
          }
        } : {}),
        ...(message.traceData ? {
          trace_data: {
            trace_id: message.traceData.traceId,
            transaction_id: message.traceData.transactionId
          }
        } : {})
      };
    })
  };
};
exports.transformToUpdateScheme = transformToUpdateScheme;