"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateAttackDiscoverySchedulesResponse = exports.UpdateAttackDiscoverySchedulesRequestParams = exports.UpdateAttackDiscoverySchedulesRequestBody = exports.GetAttackDiscoverySchedulesResponse = exports.GetAttackDiscoverySchedulesRequestParams = exports.EnableAttackDiscoverySchedulesResponse = exports.EnableAttackDiscoverySchedulesRequestParams = exports.DisableAttackDiscoverySchedulesResponse = exports.DisableAttackDiscoverySchedulesRequestParams = exports.DeleteAttackDiscoverySchedulesResponse = exports.DeleteAttackDiscoverySchedulesRequestParams = exports.CreateAttackDiscoverySchedulesResponse = exports.CreateAttackDiscoverySchedulesRequestBody = exports.AttackDiscoveryGenericResponse = exports.AttackDiscoveryGenericError = void 0;
var _zod = require("@kbn/zod");
var _schedules_api = require("./schedules_api.gen");
var _common_attributes = require("../../../../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Attack discovery scheduling API endpoint
 *   version: 2023-10-31
 */

/**
 * Object containing Attack Discovery schedule.
 */

const AttackDiscoveryGenericResponse = exports.AttackDiscoveryGenericResponse = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * Generic error response for Attack discovery schedule operations
 */

const AttackDiscoveryGenericError = exports.AttackDiscoveryGenericError = _zod.z.object({
  /**
   * HTTP status code
   */
  status_code: _zod.z.number().optional(),
  /**
   * Error type
   */
  error: _zod.z.string().optional(),
  /**
   * Human-readable error message describing what went wrong
   */
  message: _zod.z.string().optional()
});
const CreateAttackDiscoverySchedulesRequestBody = exports.CreateAttackDiscoverySchedulesRequestBody = _schedules_api.AttackDiscoveryApiScheduleCreateProps;
const CreateAttackDiscoverySchedulesResponse = exports.CreateAttackDiscoverySchedulesResponse = _schedules_api.AttackDiscoveryApiSchedule;
const DeleteAttackDiscoverySchedulesRequestParams = exports.DeleteAttackDiscoverySchedulesRequestParams = _zod.z.object({
  /**
   * The unique identifier (UUID) of the Attack Discovery schedule to delete. This ID is returned when creating a schedule and can be found in schedule listings.
   */
  id: _common_attributes.NonEmptyString
});
const DeleteAttackDiscoverySchedulesResponse = exports.DeleteAttackDiscoverySchedulesResponse = _zod.z.object({
  /**
   * The unique identifier of the deleted Attack Discovery schedule
   */
  id: _common_attributes.NonEmptyString
});
const DisableAttackDiscoverySchedulesRequestParams = exports.DisableAttackDiscoverySchedulesRequestParams = _zod.z.object({
  /**
   * The unique identifier (UUID) of the Attack Discovery schedule to disable. This ID is returned when creating a schedule and can be found in schedule listings.
   */
  id: _common_attributes.NonEmptyString
});
const DisableAttackDiscoverySchedulesResponse = exports.DisableAttackDiscoverySchedulesResponse = _zod.z.object({
  /**
   * The unique identifier of the disabled Attack Discovery schedule
   */
  id: _common_attributes.NonEmptyString
});
const EnableAttackDiscoverySchedulesRequestParams = exports.EnableAttackDiscoverySchedulesRequestParams = _zod.z.object({
  /**
   * The unique identifier (UUID) of the Attack Discovery schedule to enable. This ID is returned when creating a schedule and can be found in schedule listings.
   */
  id: _common_attributes.NonEmptyString
});
const EnableAttackDiscoverySchedulesResponse = exports.EnableAttackDiscoverySchedulesResponse = _zod.z.object({
  /**
   * The unique identifier of the enabled Attack Discovery schedule
   */
  id: _common_attributes.NonEmptyString
});
const GetAttackDiscoverySchedulesRequestParams = exports.GetAttackDiscoverySchedulesRequestParams = _zod.z.object({
  /**
   * The unique identifier (UUID) of the Attack Discovery schedule to retrieve. This ID is returned when creating a schedule and can be found in schedule listings.
   */
  id: _common_attributes.NonEmptyString
});
const GetAttackDiscoverySchedulesResponse = exports.GetAttackDiscoverySchedulesResponse = _schedules_api.AttackDiscoveryApiSchedule;
const UpdateAttackDiscoverySchedulesRequestParams = exports.UpdateAttackDiscoverySchedulesRequestParams = _zod.z.object({
  /**
   * The unique identifier (UUID) of the Attack Discovery schedule to update. This ID is returned when creating a schedule and can be found in schedule listings.
   */
  id: _common_attributes.NonEmptyString
});
const UpdateAttackDiscoverySchedulesRequestBody = exports.UpdateAttackDiscoverySchedulesRequestBody = _schedules_api.AttackDiscoveryApiScheduleUpdateProps;
const UpdateAttackDiscoverySchedulesResponse = exports.UpdateAttackDiscoverySchedulesResponse = _schedules_api.AttackDiscoveryApiSchedule;