"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetAttackDiscoveryGenerationsResponse = exports.GetAttackDiscoveryGenerationsRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _generation = require("../../../generation.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Get attack discovery generations API endpoint
 *   version: 2023-10-31
 */

const GetAttackDiscoveryGenerationsRequestQuery = exports.GetAttackDiscoveryGenerationsRequestQuery = _zod.z.object({
  /**
   * End of the time range for filtering generations. Accepts absolute timestamps (ISO 8601) or relative date math (e.g. "now", "now-24h").
   */
  end: _zod.z.string().optional(),
  /**
   * The maximum number of generations to retrieve
   */
  size: _zod.z.coerce.number().min(1).optional().default(50),
  /**
   * Start of the time range for filtering generations. Accepts absolute timestamps (ISO 8601) or relative date math (e.g. "now-7d").
   */
  start: _zod.z.string().optional()
});
const GetAttackDiscoveryGenerationsResponse = exports.GetAttackDiscoveryGenerationsResponse = _zod.z.object({
  /**
   * List of attack discovery generations
   */
  generations: _zod.z.array(_generation.AttackDiscoveryGeneration)
});