"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnallowedFieldValues = void 0;
var _get_unallowed_field_requests = require("../helpers/get_unallowed_field_requests");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUnallowedFieldValues = (esClient, items) => {
  const searches = items.reduce((acc, {
    indexName,
    indexFieldName,
    allowedValues
  }) => acc.concat([(0, _get_unallowed_field_requests.getMSearchRequestHeader)(indexName), (0, _get_unallowed_field_requests.getMSearchRequestBody)({
    indexName,
    indexFieldName,
    allowedValues
  })]), []);
  return esClient.msearch({
    searches
  });
};
exports.getUnallowedFieldValues = getUnallowedFieldValues;