"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDegradedDocsControl = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _field_constants = require("../../field_constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-discover-utils/src/components/custom_control_columns/degraded_docs_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Degraded docs control factory function.
 * @param props Optional props for the generated Control component, useful to override onClick, etc
 */
const createDegradedDocsControl = props => ({
  id: 'connectedDegradedDocs',
  render: (Control, rowProps) => {
    return /*#__PURE__*/_react.default.createElement(DegradedDocs, (0, _extends2.default)({
      Control: Control,
      rowProps: rowProps
    }, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 12
      }
    }));
  }
});
exports.createDegradedDocsControl = createDegradedDocsControl;
const actionsHeaderAriaLabelDegradedAction = _i18n.i18n.translate('discover.customControl.degradedDocArialLabel', {
  defaultMessage: 'Access to degraded docs'
});
const degradedDocButtonLabelWhenPresent = _i18n.i18n.translate('discover.customControl.degradedDocPresent', {
  defaultMessage: "This document couldn't be parsed correctly. Not all fields are properly populated."
});
const degradedDocButtonLabelWhenNotPresent = _i18n.i18n.translate('discover.customControl.degradedDocNotPresent', {
  defaultMessage: 'All fields in this document were parsed correctly'
});
const directive = /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
  css: {
    display: 'inline-block'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 19
  }
}, "METADATA _ignored");
const formattedCTAMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "discover.customControl.degradedDocDisabled",
  defaultMessage: "Degraded document field detection is disabled for this search. Consider adding {directive} to your ES|QL query.",
  values: {
    directive
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 59,
    columnNumber: 3
  }
});
const formattedCTAMessageWithAction = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "discover.customControl.degradedDocDisabled",
  defaultMessage: "Degraded document field detection is disabled for this search. Click to add {directive} to your ES|QL query.",
  values: {
    directive
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 3
  }
});
const DegradedDocs = ({
  Control,
  enabled = true,
  addIgnoredMetadataToQuery,
  rowProps: {
    record
  },
  ...props
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDegradedDocumentExists = _field_constants.DEGRADED_DOCS_FIELDS.some(field => field in record.raw && record.raw[field] !== null && record.raw[field] !== undefined);
  if (!enabled) {
    if (addIgnoredMetadataToQuery) {
      return /*#__PURE__*/_react.default.createElement(Control, {
        css: {
          color: euiTheme.colors.textDisabled
        } // Give same color as disabled
        ,
        "data-test-subj": "docTableDegradedDocDisabled",
        iconType: "indexClose",
        label: actionsHeaderAriaLabelDegradedAction,
        tooltipContent: formattedCTAMessageWithAction,
        onClick: addIgnoredMetadataToQuery,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 9
        }
      });
    } else {
      // Control without click action for saved searches in dashboards
      return /*#__PURE__*/_react.default.createElement(Control, (0, _extends2.default)({
        disabled: true,
        "data-test-subj": "docTableDegradedDocDisabled",
        tooltipContent: formattedCTAMessage,
        label: actionsHeaderAriaLabelDegradedAction,
        iconType: "indexClose",
        onClick: undefined
      }, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 9
        }
      }));
    }
  }
  return isDegradedDocumentExists ? /*#__PURE__*/_react.default.createElement(Control, (0, _extends2.default)({
    "data-test-subj": "docTableDegradedDocExist",
    color: "danger",
    tooltipContent: degradedDocButtonLabelWhenPresent,
    label: degradedDocButtonLabelWhenPresent,
    iconType: "indexClose",
    onClick: undefined
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  })) : /*#__PURE__*/_react.default.createElement(Control, (0, _extends2.default)({
    "data-test-subj": "docTableDegradedDocDoesNotExist",
    color: "text",
    tooltipContent: degradedDocButtonLabelWhenNotPresent,
    label: degradedDocButtonLabelWhenNotPresent,
    iconType: "indexClose",
    onClick: undefined
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  }));
};