"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExampleDocumentProfileProvider = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _profiles = require("../../../profiles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createExampleDocumentProfileProvider = () => ({
  profileId: 'example-document-profile',
  isExperimental: true,
  profile: {},
  resolve: params => {
    if ((0, _discoverUtils.getFieldValue)(params.record, 'data_stream.type') !== 'example') {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        type: _profiles.DocumentType.Default
      }
    };
  }
});
exports.createExampleDocumentProfileProvider = createExampleDocumentProfileProvider;