"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDefaultAdHocDataViews = void 0;
var _react = require("react");
var _useLatest = _interopRequireDefault(require("react-use/lib/useLatest"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _use_discover_services = require("../../hooks/use_discover_services");
var _redux = require("../../application/main/state_management/redux");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Hook to retrieve and initialize the default profile ad hoc data views
 * @param Options The options object
 * @returns An object containing the initialization function
 */
const useDefaultAdHocDataViews = () => {
  const {
    dataViews
  } = (0, _use_discover_services.useDiscoverServices)();
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const defaultProfileAdHocDataViewIds = (0, _redux.useInternalStateSelector)(state => state.defaultProfileAdHocDataViewIds);
  const initializeDataViews = (0, _useLatest.default)(async rootProfileState => {
    // Clear the cache of old data views before creating
    // the new ones to avoid cache hits on duplicate IDs
    for (const prevId of defaultProfileAdHocDataViewIds) {
      dataViews.clearInstanceCache(prevId);
    }
    const profileDataViewSpecs = rootProfileState.getDefaultAdHocDataViews();
    const profileDataViews = await Promise.all(profileDataViewSpecs.map(spec => dataViews.create({
      ...spec,
      managed: true
    }, true)));
    dispatch(_redux.internalStateActions.setDefaultProfileAdHocDataViews(profileDataViews));
  });

  // This approach allows us to return a callback with a stable reference
  const [initializeProfileDataViews] = (0, _react.useState)(() => {
    return (...params) => initializeDataViews.current(...params);
  });

  // Make sure to clean up on unmount
  (0, _useUnmount.default)(() => {
    for (const prevId of defaultProfileAdHocDataViewIds) {
      dataViews.clearInstanceCache(prevId);
    }
    dispatch(_redux.internalStateActions.setDefaultProfileAdHocDataViews([]));
  });
  return {
    initializeProfileDataViews
  };
};
exports.useDefaultAdHocDataViews = useDefaultAdHocDataViews;