"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentViewModeToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _discoverUtils = require("@kbn/discover-utils");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _constants = require("../../../common/constants");
var _use_discover_services = require("../../hooks/use_discover_services");
var _hits_counter = require("../hits_counter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/components/view_mode_toggle/view_mode_toggle.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DocumentViewModeToggle = ({
  viewMode,
  isEsqlMode,
  prepend,
  stateContainer,
  setDiscoverViewMode,
  patternCount,
  dataView
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    uiSettings,
    dataVisualizer: dataVisualizerService,
    aiops: aiopsService
  } = (0, _use_discover_services.useDiscoverServices)();
  const [showPatternAnalysisTab, setShowPatternAnalysisTab] = (0, _react.useState)(null);
  const showFieldStatisticsTab = (0, _react.useMemo)(() =>
  // If user opens saved search with field stats in ES|QL,
  // we show the toggle with the mode disabled so user can switch to document view
  // instead of auto-directing
  viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL && isEsqlMode || !isEsqlMode && uiSettings.get(_discoverUtils.SHOW_FIELD_STATISTICS) && dataVisualizerService !== undefined, [dataVisualizerService, uiSettings, isEsqlMode, viewMode]);
  const isMounted = (0, _useMountedState.default)();
  const setShowPatternAnalysisTabWrapper = (0, _react.useCallback)(value => {
    if (isMounted()) {
      setShowPatternAnalysisTab(value);
    }
  }, [isMounted]);
  (0, _react.useEffect)(function checkForPatternAnalysis() {
    if (!aiopsService || isEsqlMode) {
      setShowPatternAnalysisTab(false);
      return;
    }
    aiopsService.getPatternAnalysisAvailable().then(patternAnalysisAvailable => {
      const available = patternAnalysisAvailable(dataView);
      setShowPatternAnalysisTabWrapper(available);
    }).catch(() => setShowPatternAnalysisTabWrapper(false));
  }, [aiopsService, dataView, isEsqlMode, setShowPatternAnalysisTabWrapper]);
  (0, _react.useEffect)(() => {
    if (showPatternAnalysisTab === false && viewMode === _constants.VIEW_MODE.PATTERN_LEVEL) {
      // switch to document view if no text fields are available
      setDiscoverViewMode(_constants.VIEW_MODE.DOCUMENT_LEVEL);
    }
  }, [showPatternAnalysisTab, viewMode, setDiscoverViewMode]);
  const includesNormalTabsStyle = viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL;
  const containerPadding = includesNormalTabsStyle ? euiTheme.size.s : 0;
  const containerCss = (0, _react2.css)`
    padding: ${containerPadding} ${containerPadding} 0 ${containerPadding};
  `;
  const tabsCss = (0, _react2.css)`
    .euiTab__content {
      line-height: ${euiTheme.size.xl};
    }
  `;
  (0, _react.useEffect)(() => {
    if (viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL && isEsqlMode) {
      setDiscoverViewMode(_constants.VIEW_MODE.DOCUMENT_LEVEL);
    }
  }, [viewMode, isEsqlMode, setDiscoverViewMode]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    css: containerCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, prepend && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            &:empty {
              display: none;
            }
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, prepend), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, showFieldStatisticsTab === false && showPatternAnalysisTab === false ? /*#__PURE__*/_react.default.createElement(_hits_counter.HitsCounter, {
    mode: _hits_counter.HitsCounterMode.standalone,
    stateContainer: stateContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "m",
    css: tabsCss,
    "data-test-subj": "dscViewModeToggle",
    bottomBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: viewMode === _constants.VIEW_MODE.DOCUMENT_LEVEL,
    onClick: () => setDiscoverViewMode(_constants.VIEW_MODE.DOCUMENT_LEVEL),
    "data-test-subj": "dscViewModeDocumentButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }, isEsqlMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.esql.label",
    defaultMessage: "Results",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.document.label",
    defaultMessage: "Documents",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_hits_counter.HitsCounter, {
    mode: _hits_counter.HitsCounterMode.appended,
    stateContainer: stateContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  })), showPatternAnalysisTab ? /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: viewMode === _constants.VIEW_MODE.PATTERN_LEVEL,
    onClick: () => setDiscoverViewMode(_constants.VIEW_MODE.PATTERN_LEVEL),
    "data-test-subj": "dscViewModePatternAnalysisButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.patternAnalysis.label",
    defaultMessage: "Patterns {patternCount}",
    values: {
      patternCount: patternCount !== undefined ? ` (${patternCount})` : ''
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 17
    }
  })) : null, showFieldStatisticsTab ? /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    disabled: isEsqlMode,
    isSelected: viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL,
    onClick: () => setDiscoverViewMode(_constants.VIEW_MODE.AGGREGATED_LEVEL),
    "data-test-subj": "dscViewModeFieldStatsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.fieldStatistics.label",
    defaultMessage: "Field statistics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 17
    }
  })) : null)));
};
exports.DocumentViewModeToggle = DocumentViewModeToggle;