"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatisticsTab = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_query_subscriber = require("@kbn/unified-field-list/src/hooks/use_query_subscriber");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _field_stats_table = require("./field_stats_table");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/field_stats_table/field_stats_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const FieldStatisticsTab = exports.FieldStatisticsTab = /*#__PURE__*/_react.default.memo(props => {
  var _services$dataVisuali;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    query,
    filters
  } = (0, _use_query_subscriber.useQuerySubscriber)({
    data: services.data
  });
  const isEsql = (0, _use_is_esql_mode.useIsEsqlMode)();

  // Quit early if we know it's in ES|QL mode
  if (isEsql && (_services$dataVisuali = services.dataVisualizer) !== null && _services$dataVisuali !== void 0 && _services$dataVisuali.FieldStatsUnavailableMessage) {
    return /*#__PURE__*/_react.default.createElement(services.dataVisualizer.FieldStatsUnavailableMessage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_field_stats_table.FieldStatisticsTable, {
    dataView: props.dataView,
    columns: props.columns,
    stateContainer: props.stateContainer,
    onAddFilter: props.onAddFilter,
    trackUiMetric: props.trackUiMetric,
    isEsqlMode: props.isEsqlMode,
    query: query,
    filters: filters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  });
});