"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inject = exports.extract = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const inject = (state, injectedReferences) => {
  if (hasAttributes(state)) {
    // Filter out references that are not in the state
    // https://github.com/elastic/kibana/pull/119079
    const references = state.attributes.references.map(stateRef => injectedReferences.find(injectedRef => injectedRef.name === stateRef.name)).filter(Boolean);
    state = {
      ...state,
      attributes: {
        ...state.attributes,
        references
      }
    };
  }
  return state;
};
exports.inject = inject;
const extract = state => {
  let references = [];
  if (hasAttributes(state)) {
    references = state.attributes.references;
  }
  return {
    state,
    references
  };
};
exports.extract = extract;
const hasAttributes = state => 'attributes' in state;