"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TELEMETRY_TASK_TIMEOUT = exports.TELEMETRY_TASK_INTERVAL = exports.PROMINENT_LOG_ECS_FIELDS = exports.NON_LOG_SIGNALS = exports.MAX_STREAMS_TO_REPORT = exports.LOGS_DATA_TELEMETRY_TASK_TYPE = exports.LOGS_DATA_TELEMETRY_TASK_ID = exports.LOGS_DATASET_INDEX_PATTERNS = exports.LEVEL_2_RESOURCE_FIELDS = exports.EXCLUDE_ELASTIC_LOGS = exports.DATA_TELEMETRY_FIELDS = exports.BREATHE_DELAY_SHORT = exports.BREATHE_DELAY_MEDIUM = void 0;
var _constants = require("@kbn/telemetry-plugin/server/telemetry_collection/get_data_telemetry/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOGS_DATA_TELEMETRY_TASK_TYPE = exports.LOGS_DATA_TELEMETRY_TASK_TYPE = 'logs-data-telemetry';
const LOGS_DATA_TELEMETRY_TASK_ID = exports.LOGS_DATA_TELEMETRY_TASK_ID = 'logs-data-telemetry:collect-and-report-task';
const TELEMETRY_TASK_INTERVAL = exports.TELEMETRY_TASK_INTERVAL = 24 * 60; // 24 hours (in minutes)
const TELEMETRY_TASK_TIMEOUT = exports.TELEMETRY_TASK_TIMEOUT = 10; // 10 minutes

const BREATHE_DELAY_SHORT = exports.BREATHE_DELAY_SHORT = 1000; // 1 seconds
const BREATHE_DELAY_MEDIUM = exports.BREATHE_DELAY_MEDIUM = 5 * 1000; // 5 seconds

const MAX_STREAMS_TO_REPORT = exports.MAX_STREAMS_TO_REPORT = 1000;
const NON_LOG_SIGNALS = exports.NON_LOG_SIGNALS = ['metrics', 'traces', 'internal', 'synthetics'];
const EXCLUDE_ELASTIC_LOGS = exports.EXCLUDE_ELASTIC_LOGS = ['logs-synth', 'logs-elastic', 'logs-endpoint'];
const LOGS_INDEX_PATTERN_NAMES = ['filebeat', 'generic-filebeat', 'metricbeat', 'generic-metricbeat', 'apm', 'functionbeat', 'generic-functionbeat', 'heartbeat', 'generic-heartbeat', 'logstash', 'generic-logstash', 'fluentd', 'telegraf', 'prometheusbeat', 'fluentbit', 'nginx', 'apache', 'dsns-logs', 'generic-logs'];
const TELEMETRY_PATTERNS_BY_NAME = _constants.DATA_DATASETS_INDEX_PATTERNS_UNIQUE.reduce((acc, pattern) => {
  acc[pattern.patternName] = [pattern, ...(acc[pattern.patternName] || [])];
  return acc;
}, {});
const LOGS_DATASET_INDEX_PATTERNS = exports.LOGS_DATASET_INDEX_PATTERNS = LOGS_INDEX_PATTERN_NAMES.flatMap(patternName => TELEMETRY_PATTERNS_BY_NAME[patternName] || []);
const LEVEL_2_RESOURCE_FIELDS = exports.LEVEL_2_RESOURCE_FIELDS = ['host.name', 'service.name', 'host', 'hostname', 'host_name'];
const PROMINENT_LOG_ECS_FIELDS = exports.PROMINENT_LOG_ECS_FIELDS = ['log.level', 'log.logger', 'log.origin.file.name', 'log.origin.function', 'log.origin.file.line', 'event.action', 'event.category', 'event.dataset', 'event.kind', 'log.file.path'];
const DATA_TELEMETRY_FIELDS = exports.DATA_TELEMETRY_FIELDS = ['container.id', 'log.level', 'container.name', 'host.name', 'host.hostname', 'kubernetes.pod.name', 'kubernetes.pod.uid', 'cloud.provider', 'agent.type', 'event.dataset', 'event.category', 'event.module', 'service.name', 'service.type', 'service.version', 'message', 'event.original', 'error.message', '@timestamp', 'data_stream.dataset', 'data_stream.namespace', 'data_stream.type'];