"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocsStats = void 0;
var _fetch_es_query = require("./fetch_es_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDocsStats = async ({
  index,
  dateStart,
  groupBy,
  query,
  scopedClusterClient
}) => {
  const dataStreamTotalDocsResults = await (0, _fetch_es_query.fetchEsQuery)({
    index,
    dateStart,
    groupBy,
    services: {
      scopedClusterClient
    }
  });
  const dataStreamQueryDocsResults = await (0, _fetch_es_query.fetchEsQuery)({
    index,
    dateStart,
    groupBy,
    query,
    services: {
      scopedClusterClient
    }
  });
  return Object.keys(dataStreamTotalDocsResults).map(key => {
    var _dataStreamQueryDocsR, _dataStreamQueryDocsR2, _dataStreamTotalDocsR, _dataStreamTotalDocsR2, _dataStreamQueryDocsR3;
    const totalDocs = dataStreamTotalDocsResults[key].docCount;
    const queryDocs = (_dataStreamQueryDocsR = (_dataStreamQueryDocsR2 = dataStreamQueryDocsResults[key]) === null || _dataStreamQueryDocsR2 === void 0 ? void 0 : _dataStreamQueryDocsR2.docCount) !== null && _dataStreamQueryDocsR !== void 0 ? _dataStreamQueryDocsR : 0;
    const bucketKey = (_dataStreamTotalDocsR = (_dataStreamTotalDocsR2 = dataStreamTotalDocsResults[key]) === null || _dataStreamTotalDocsR2 === void 0 ? void 0 : _dataStreamTotalDocsR2.bucketKey) !== null && _dataStreamTotalDocsR !== void 0 ? _dataStreamTotalDocsR : (_dataStreamQueryDocsR3 = dataStreamQueryDocsResults[key]) === null || _dataStreamQueryDocsR3 === void 0 ? void 0 : _dataStreamQueryDocsR3.bucketKey;
    return {
      bucketKey,
      percentage: totalDocs ? queryDocs / totalDocs * 100 : 0
    };
  });
};
exports.getDocsStats = getDocsStats;