"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DegradedDocsRuleType = DegradedDocsRuleType;
exports.viewInAppUrlActionVariableDescription = exports.actionVariableContextReasonLabel = void 0;
var _server = require("@kbn/core/server");
var _i18n = require("@kbn/i18n");
var _degraded_docs = require("@kbn/response-ops-rule-params/degraded_docs");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _types = require("../types");
var _executor = require("./executor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DegradedDocsRuleType(locatorsClient) {
  return {
    id: _ruleDataUtils.DEGRADED_DOCS_RULE_TYPE_ID,
    name: _i18n.i18n.translate('xpack.datasetQuality.rule.degradedDocs.name', {
      defaultMessage: 'Degraded docs'
    }),
    solution: 'stack',
    validate: {
      params: _degraded_docs.degradedDocsParamsSchema
    },
    schemas: {
      params: {
        type: 'config-schema',
        schema: _degraded_docs.degradedDocsParamsSchema
      }
    },
    defaultActionGroupId: _types.THRESHOLD_MET_GROUP.id,
    actionGroups: [_types.THRESHOLD_MET_GROUP],
    category: _server.DEFAULT_APP_CATEGORIES.management.id,
    producer: _ruleDataUtils.STACK_ALERTS_FEATURE_ID,
    minimumLicenseRequired: 'basic',
    isExportable: true,
    executor: (0, _executor.getRuleExecutor)(locatorsClient),
    doesSetRecoveryContext: true,
    actionVariables: {
      context: [{
        name: 'reason',
        description: actionVariableContextReasonLabel
      }, {
        name: 'value',
        description: actionVariableContextValueLabel
      }, {
        name: 'grouping',
        description: actionVariableContextGroupingLabel
      }, {
        name: 'threshold',
        description: actionVariableContextThresholdLabel
      }, {
        name: 'viewInAppUrl',
        description: viewInAppUrlActionVariableDescription
      }]
    },
    alerts: {
      context: _types.DATASET_QUALITY_REGISTRATION_CONTEXT,
      mappings: {
        fieldMap: {
          [_ruleDataUtils.ALERT_REASON]: {
            type: 'keyword',
            array: false,
            required: false
          },
          [_ruleDataUtils.ALERT_EVALUATION_VALUE]: {
            type: 'keyword',
            array: false,
            required: false
          },
          [_ruleDataUtils.ALERT_EVALUATION_THRESHOLD]: {
            type: 'scaled_float',
            scaling_factor: 100,
            required: false
          },
          [_ruleDataUtils.ALERT_GROUPING]: {
            type: 'object',
            dynamic: true,
            array: false,
            required: false
          }
        },
        dynamicTemplates: [{
          strings_as_keywords: {
            path_match: 'kibana.alert.grouping.*',
            match_mapping_type: 'string',
            mapping: {
              type: 'keyword',
              ignore_above: 1024
            }
          }
        }]
      },
      shouldWrite: true,
      useEcs: true
    }
  };
}
const actionVariableContextReasonLabel = exports.actionVariableContextReasonLabel = _i18n.i18n.translate('xpack.datasetQuality.alerting.actionVariableContextReasonLabel', {
  defaultMessage: 'A concise description of the reason for the alert.'
});
const actionVariableContextValueLabel = _i18n.i18n.translate('xpack.datasetQuality.alerting.actionVariableContextValueLabel', {
  defaultMessage: 'The value that met the threshold condition.'
});
const actionVariableContextThresholdLabel = _i18n.i18n.translate('xpack.datasetQuality.alerting.actionVariableContextThresholdLabel', {
  defaultMessage: 'An array of rule threshold values. For between and notBetween thresholds, there are two values.'
});
const actionVariableContextGroupingLabel = _i18n.i18n.translate('xpack.datasetQuality.alerting.actionVariableContextGrouping', {
  defaultMessage: 'The object containing groups that are reporting data'
});
const viewInAppUrlActionVariableDescription = exports.viewInAppUrlActionVariableDescription = _i18n.i18n.translate('xpack.datasetQuality.alerting.actionVariableContextViewInAppUrl', {
  defaultMessage: 'Link to the alert source'
});