"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleTypesRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _create_datasets_quality_server_route = require("../create_datasets_quality_server_route");
var _get_chart_preview = require("../../rule_types/degraded_docs/get_chart_preview");
var _default_api_types = require("../../types/default_api_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const degradedDocsChartPreviewRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/rule_types/degraded_docs/chart_preview',
  params: t.type({
    query: t.type({
      index: t.string,
      groupBy: _default_api_types.groupByRt,
      start: t.string,
      end: t.string,
      interval: t.string
    })
  }),
  options: {
    tags: []
  },
  security: {
    authz: {
      enabled: false,
      reason: 'This API delegates security to the currently logged in user and their Elasticsearch permissions.'
    }
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const degradedDocsChartPreview = await (0, _get_chart_preview.getChartPreview)({
      esClient,
      ...params.query
    });
    return {
      ...degradedDocsChartPreview
    };
  }
});
const ruleTypesRouteRepository = exports.ruleTypesRouteRepository = {
  ...degradedDocsChartPreviewRoute
};