"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntegrationDashboards = getIntegrationDashboards;
var _constants = require("@kbn/deeplinks-analytics/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getIntegrationDashboards(packageClient, savedObjectsClient, integration) {
  // Retrieve integration savedObject
  const integrationSavedObjects = await packageClient.getInstallation(integration);
  if (!integrationSavedObjects) return [];

  // Extract dashboard ids
  const dashboardIds = [];
  integrationSavedObjects.installed_kibana.forEach(intSavedObject => {
    if (intSavedObject.type === _constants.DASHBOARD_SAVED_OBJECT_TYPE) {
      dashboardIds.push(intSavedObject.id);
    }
  });

  // Fetch dashboards savedObject
  // We are directly querying the SO here
  // The dashboard service is not exposed from the server side at the moment
  // https://github.com/elastic/kibana/issues/179759
  const dashboardsSavedObjects = await savedObjectsClient.bulkGet(dashboardIds.map(id => ({
    id,
    type: _constants.DASHBOARD_SAVED_OBJECT_TYPE,
    fields: ['title']
  })));

  // Ignore faulty dashboards
  const allValidDashboardSavedObjects = dashboardsSavedObjects.saved_objects.filter(so => !so.error);

  // Construct dashboard result
  const packageDashboards = allValidDashboardSavedObjects.map(so => ({
    id: so.id,
    title: so.attributes.title || so.id
  }));
  return packageDashboards;
}