"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailedDocsErrors = getFailedDocsErrors;
var _constants = require("../../../../common/constants");
var _es_fields = require("../../../../common/es_fields");
var _utils = require("../../../utils");
var _queries = require("../../../utils/queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ERRORS = 100;
const MAX_EXAMPLES_PER_ERROR = 10;
async function getFailedDocsErrors({
  esClient,
  start,
  end,
  dataStream
}) {
  var _response$aggregation, _response$aggregation2;
  const datasetQualityESClient = (0, _utils.createDatasetQualityESClient)(esClient);
  const bool = {
    filter: [...(0, _queries.rangeQuery)(start, end)]
  };
  const response = await datasetQualityESClient.search({
    index: `${dataStream}${_constants.FAILURE_STORE_SELECTOR}`,
    size: 0,
    query: {
      bool
    },
    aggs: {
      by_error_type: {
        terms: {
          field: _es_fields.ERROR_TYPE,
          size: MAX_ERRORS
        },
        aggs: {
          example_failure: {
            top_hits: {
              size: MAX_EXAMPLES_PER_ERROR,
              _source: [_es_fields.ERROR_MESSAGE]
            }
          }
        }
      }
    }
  });
  const errors = extractAndDeduplicateValues((_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.by_error_type.buckets) !== null && _response$aggregation !== void 0 ? _response$aggregation : []);
  return {
    errors
  };
}
function extractAndDeduplicateValues(buckets) {
  return buckets.flatMap(bucket => {
    var _bucket$example_failu, _bucket$example_failu2, _bucket$example_failu3;
    const type = String(bucket.key);
    const hits = (_bucket$example_failu = (_bucket$example_failu2 = bucket.example_failure) === null || _bucket$example_failu2 === void 0 ? void 0 : (_bucket$example_failu3 = _bucket$example_failu2.hits) === null || _bucket$example_failu3 === void 0 ? void 0 : _bucket$example_failu3.hits) !== null && _bucket$example_failu !== void 0 ? _bucket$example_failu : [];
    const uniqueMessages = new Set(hits.map(hit => {
      var _error;
      return (_error = hit._source.error) === null || _error === void 0 ? void 0 : _error.message;
    }).filter(message => Boolean(message)));
    return Array.from(uniqueMessages, message => ({
      type,
      message
    }));
  });
}