"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUiActions = registerUiActions;
var _fileUploadCommon = require("@kbn/file-upload-common");
var _file_upload_lite_action = require("./application/file_data_visualizer/new/file_upload_lite_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerUiActions(coreStart, plugins) {
  const {
    uiActions
  } = plugins;
  if (uiActions === undefined) {
    return;
  }
  const categorizationADJobAction = (0, _file_upload_lite_action.createOpenFileUploadLiteAction)(coreStart, plugins);
  uiActions.registerTrigger(_file_upload_lite_action.createOpenFileUploadLiteTrigger);
  uiActions.addTriggerActionAsync(_fileUploadCommon.OPEN_FILE_UPLOAD_LITE_TRIGGER, _fileUploadCommon.OPEN_FILE_UPLOAD_LITE_ACTION, async () => categorizationADJobAction);
}