"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getESQLBooleanFieldStats = void 0;
var _common = require("@kbn/data-plugin/common");
var _pLimit = _interopRequireDefault(require("p-limit"));
var _esqlUtils = require("@kbn/esql-utils");
var _esql_utils = require("../requests/esql_utils");
var _promise_all_settled_utils = require("../../../common/util/promise_all_settled_utils");
var _index_data_visualizer_viewer = require("../../constants/index_data_visualizer_viewer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getESQLBooleanFieldStats = async ({
  runRequest,
  columns,
  esqlBaseQuery,
  filter,
  timeRange
}) => {
  const limiter = (0, _pLimit.default)(_index_data_visualizer_viewer.MAX_CONCURRENT_REQUESTS);
  const namedParams = (0, _esqlUtils.getStartEndParams)(esqlBaseQuery, timeRange);
  const booleanFields = columns.filter(f => f.secondaryType === 'boolean').map(field => {
    const query = (0, _esqlUtils.appendToESQLQuery)(esqlBaseQuery, `| STATS ${(0, _esql_utils.getSafeESQLName)(`${field.name}_terms`)} = count(${(0, _esql_utils.getSafeESQLName)(field.name)}) BY ${(0, _esql_utils.getSafeESQLName)(field.name)}
        | LIMIT 3`);
    return {
      field,
      request: {
        params: {
          query,
          ...(filter ? {
            filter
          } : {}),
          ...(namedParams.length ? {
            params: namedParams
          } : {})
        }
      }
    };
  });
  if (booleanFields.length > 0) {
    const booleanTopTermsResp = await Promise.allSettled(booleanFields.map(({
      request
    }) => limiter(() => runRequest(request, {
      strategy: _common.ESQL_ASYNC_SEARCH_STRATEGY
    }))));
    if (booleanTopTermsResp) {
      return booleanFields.map(({
        field,
        request
      }, idx) => {
        const resp = booleanTopTermsResp[idx];
        if (!resp) return;
        if ((0, _promise_all_settled_utils.isFulfilled)(resp) && resp.value) {
          const results = resp.value.rawResponse.values;
          const topValuesSampleSize = results.reduce((acc, row) => acc + row[0], 0);
          let falseCount = 0;
          let trueCount = 0;
          const terms = results.map(row => {
            if (row[1] === false) {
              falseCount = row[0];
            }
            if (row[1] === true) {
              trueCount = row[0];
            }
            return {
              key_as_string: row[1] === false ? 'false' : 'true',
              doc_count: row[0],
              percent: row[0] / topValuesSampleSize
            };
          });
          return {
            fieldName: field.name,
            topValues: terms,
            topValuesSampleSize,
            topValuesSamplerShardSize: topValuesSampleSize,
            isTopValuesSampled: false,
            trueCount,
            falseCount,
            count: trueCount + falseCount
          };
        }
        if ((0, _promise_all_settled_utils.isRejected)(resp)) {
          // Log for debugging purposes
          // eslint-disable-next-line no-console
          console.error(resp, request);
          return {
            fieldName: field.name,
            error: resp.reason
          };
        }
      });
    }
  }
  return [];
};
exports.getESQLBooleanFieldStats = getESQLBooleanFieldStats;